/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * These settings are only used for e-mail documents. The \&quot;MIME\&quot; (eml; RFC-822) and Outlook (msg) e-mail formats are supported.
 */
@Schema(description = "These settings are only used for e-mail documents. The \"MIME\" (eml; RFC-822) and Outlook (msg) e-mail formats are supported.")
@JsonPropertyOrder({
  OperationConverterMail.JSON_PROPERTY_ADJUST_FONTS,
  OperationConverterMail.JSON_PROPERTY_ATTACHMENT_MODE,
  OperationConverterMail.JSON_PROPERTY_DOWNLOAD_IMAGES,
  OperationConverterMail.JSON_PROPERTY_IGNORE_MISSING_BODY_CHUNK,
  OperationConverterMail.JSON_PROPERTY_RESIZE_IMAGES,
  OperationConverterMail.JSON_PROPERTY_RESIZE_TABLES,
  OperationConverterMail.JSON_PROPERTY_USE_BACKGROUND
})
@JsonTypeName("Operation_ConverterMail")

public class OperationConverterMail {
  public static final String JSON_PROPERTY_ADJUST_FONTS = "adjustFonts";
  private Boolean adjustFonts = false;

  /**
   * Specifies the manner in which attachments are to be processed in e-mails.  *   embed &#x3D; Embed in original format *   remove &#x3D; Remove attachments *   convert &#x3D; Converts the attachments to PDF format and embeds them as an attachment *   convertMerge &#x3D; Converts the attachments to PDF format and appends them as additional page(s) at the end  **Important:** If conversion to PDF format is not possible when using \&quot;convert\&quot; or \&quot;convertMerge\&quot;, the attachment will be embedded in its original format.
   */
  public enum AttachmentModeEnum {
    EMBED("embed"),
    
    REMOVE("remove"),
    
    CONVERT("convert"),
    
    CONVERTMERGE("convertMerge"),
    
    CONVERTEMBED("convertEmbed"),
    
    CONVERTMERGEEMBED("convertMergeEmbed");

    private String value;

    AttachmentModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AttachmentModeEnum fromValue(String value) {
      for (AttachmentModeEnum b : AttachmentModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ATTACHMENT_MODE = "attachmentMode";
  private AttachmentModeEnum attachmentMode = AttachmentModeEnum.EMBED;

  public static final String JSON_PROPERTY_DOWNLOAD_IMAGES = "downloadImages";
  private Boolean downloadImages = false;

  public static final String JSON_PROPERTY_IGNORE_MISSING_BODY_CHUNK = "ignoreMissingBodyChunk";
  private Boolean ignoreMissingBodyChunk = false;

  public static final String JSON_PROPERTY_RESIZE_IMAGES = "resizeImages";
  private Boolean resizeImages = false;

  public static final String JSON_PROPERTY_RESIZE_TABLES = "resizeTables";
  private Boolean resizeTables = false;

  public static final String JSON_PROPERTY_USE_BACKGROUND = "useBackground";
  private Boolean useBackground = true;

  public OperationConverterMail() {
  }

  public OperationConverterMail adjustFonts(Boolean adjustFonts) {
    
    this.adjustFonts = adjustFonts;
    return this;
  }

  /**
   * If \&quot;true\&quot;, then the font specifications \&quot;Arial\&quot;, \&quot;Helvetica\&quot; and \&quot;Sans-Serif\&quot; in HTML documents and e-mails (which are based on HTML) are automatically replaced by the \&quot;Arial Unicode MS\&quot; font. The improves the appearance of the typeface in the PDF result.
   * @return adjustFonts
   **/
  @Nullable
  @Schema(name = "If \"true\", then the font specifications \"Arial\", \"Helvetica\" and \"Sans-Serif\" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the \"Arial Unicode MS\" font. The improves the appearance of the typeface in the PDF result.")
  @JsonProperty(JSON_PROPERTY_ADJUST_FONTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAdjustFonts() {
    return adjustFonts;
  }


  @JsonProperty(JSON_PROPERTY_ADJUST_FONTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdjustFonts(Boolean adjustFonts) {
    this.adjustFonts = adjustFonts;
  }


  public OperationConverterMail attachmentMode(AttachmentModeEnum attachmentMode) {
    
    this.attachmentMode = attachmentMode;
    return this;
  }

  /**
   * Specifies the manner in which attachments are to be processed in e-mails.  *   embed &#x3D; Embed in original format *   remove &#x3D; Remove attachments *   convert &#x3D; Converts the attachments to PDF format and embeds them as an attachment *   convertMerge &#x3D; Converts the attachments to PDF format and appends them as additional page(s) at the end  **Important:** If conversion to PDF format is not possible when using \&quot;convert\&quot; or \&quot;convertMerge\&quot;, the attachment will be embedded in its original format.
   * @return attachmentMode
   **/
  @Nullable
  @Schema(name = "Specifies the manner in which attachments are to be processed in e-mails.  *   embed = Embed in original format *   remove = Remove attachments *   convert = Converts the attachments to PDF format and embeds them as an attachment *   convertMerge = Converts the attachments to PDF format and appends them as additional page(s) at the end  **Important:** If conversion to PDF format is not possible when using \"convert\" or \"convertMerge\", the attachment will be embedded in its original format.")
  @JsonProperty(JSON_PROPERTY_ATTACHMENT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AttachmentModeEnum getAttachmentMode() {
    return attachmentMode;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENT_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachmentMode(AttachmentModeEnum attachmentMode) {
    this.attachmentMode = attachmentMode;
  }


  public OperationConverterMail downloadImages(Boolean downloadImages) {
    
    this.downloadImages = downloadImages;
    return this;
  }

  /**
   * If \&quot;true\&quot;, then the images of an e-mail or an HTML document are downloaded automatically. This option could slow down the conversion considerably if there are many images contained or if, for example, e-mail documents are converted in which the images can no longer be invoked.
   * @return downloadImages
   **/
  @Nullable
  @Schema(name = "If \"true\", then the images of an e-mail or an HTML document are downloaded automatically. This option could slow down the conversion considerably if there are many images contained or if, for example, e-mail documents are converted in which the images can no longer be invoked.")
  @JsonProperty(JSON_PROPERTY_DOWNLOAD_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDownloadImages() {
    return downloadImages;
  }


  @JsonProperty(JSON_PROPERTY_DOWNLOAD_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDownloadImages(Boolean downloadImages) {
    this.downloadImages = downloadImages;
  }


  public OperationConverterMail ignoreMissingBodyChunk(Boolean ignoreMissingBodyChunk) {
    
    this.ignoreMissingBodyChunk = ignoreMissingBodyChunk;
    return this;
  }

  /**
   * If this option is enabled, an error will not be triggered (the conversion will not be aborted) for e-mails if there is no body element in the file structure. However, this should not be confused with an e-mail not having any content.
   * @return ignoreMissingBodyChunk
   **/
  @Nullable
  @Schema(name = "If this option is enabled, an error will not be triggered (the conversion will not be aborted) for e-mails if there is no body element in the file structure. However, this should not be confused with an e-mail not having any content.")
  @JsonProperty(JSON_PROPERTY_IGNORE_MISSING_BODY_CHUNK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIgnoreMissingBodyChunk() {
    return ignoreMissingBodyChunk;
  }


  @JsonProperty(JSON_PROPERTY_IGNORE_MISSING_BODY_CHUNK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIgnoreMissingBodyChunk(Boolean ignoreMissingBodyChunk) {
    this.ignoreMissingBodyChunk = ignoreMissingBodyChunk;
  }


  public OperationConverterMail resizeImages(Boolean resizeImages) {
    
    this.resizeImages = resizeImages;
    return this;
  }

  /**
   * If true, then an attempt is made to fit all images that are not in a table to the maximum page width in the PDF document. The graphics will be scaled (while maintaining the aspect ratio) to fit the width of the page and not be cut off. Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to the scaling.  **Important:** If the \&quot;resizeImages\&quot; option is enabled, you must expect that the original appearance of the e-mail document will no longer be preserved.
   * @return resizeImages
   **/
  @Nullable
  @Schema(name = "If true, then an attempt is made to fit all images that are not in a table to the maximum page width in the PDF document. The graphics will be scaled (while maintaining the aspect ratio) to fit the width of the page and not be cut off. Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to the scaling.  **Important:** If the \"resizeImages\" option is enabled, you must expect that the original appearance of the e-mail document will no longer be preserved.")
  @JsonProperty(JSON_PROPERTY_RESIZE_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResizeImages() {
    return resizeImages;
  }


  @JsonProperty(JSON_PROPERTY_RESIZE_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResizeImages(Boolean resizeImages) {
    this.resizeImages = resizeImages;
  }


  public OperationConverterMail resizeTables(Boolean resizeTables) {
    
    this.resizeTables = resizeTables;
    return this;
  }

  /**
   * If true, then an attempt is made to fit all tables to the maximum page width in the PDF document. An attempt is made to reduce the individual columns of a table so that the table fits completely within the page width. This works only for simple tables originally defined with dynamic sizes and not for nested tables (table-in-table). Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to scaling.  **Important:** If the option \&quot;resizeTables\&quot; is activated, you must expect that the original appearance of the e-mail document is no longer preserved. The recalculation of the table columns may also result in very narrow columns in the output.
   * @return resizeTables
   **/
  @Nullable
  @Schema(name = "If true, then an attempt is made to fit all tables to the maximum page width in the PDF document. An attempt is made to reduce the individual columns of a table so that the table fits completely within the page width. This works only for simple tables originally defined with dynamic sizes and not for nested tables (table-in-table). Please note that this may cause the original formatting of the email to be lost or to deviate from the original due to scaling.  **Important:** If the option \"resizeTables\" is activated, you must expect that the original appearance of the e-mail document is no longer preserved. The recalculation of the table columns may also result in very narrow columns in the output.")
  @JsonProperty(JSON_PROPERTY_RESIZE_TABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResizeTables() {
    return resizeTables;
  }


  @JsonProperty(JSON_PROPERTY_RESIZE_TABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResizeTables(Boolean resizeTables) {
    this.resizeTables = resizeTables;
  }


  public OperationConverterMail useBackground(Boolean useBackground) {
    
    this.useBackground = useBackground;
    return this;
  }

  /**
   * If \&quot;true\&quot;, then a background defined in the e-mail (in the HTML content) is also output in the PDF document. If \&quot;false\&quot;, the background will be hidden.
   * @return useBackground
   **/
  @Nullable
  @Schema(name = "If \"true\", then a background defined in the e-mail (in the HTML content) is also output in the PDF document. If \"false\", the background will be hidden.")
  @JsonProperty(JSON_PROPERTY_USE_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseBackground() {
    return useBackground;
  }


  @JsonProperty(JSON_PROPERTY_USE_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseBackground(Boolean useBackground) {
    this.useBackground = useBackground;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationConverterMail operationConverterMail = (OperationConverterMail) o;
    return Objects.equals(this.adjustFonts, operationConverterMail.adjustFonts) &&
        Objects.equals(this.attachmentMode, operationConverterMail.attachmentMode) &&
        Objects.equals(this.downloadImages, operationConverterMail.downloadImages) &&
        Objects.equals(this.ignoreMissingBodyChunk, operationConverterMail.ignoreMissingBodyChunk) &&
        Objects.equals(this.resizeImages, operationConverterMail.resizeImages) &&
        Objects.equals(this.resizeTables, operationConverterMail.resizeTables) &&
        Objects.equals(this.useBackground, operationConverterMail.useBackground);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adjustFonts, attachmentMode, downloadImages, ignoreMissingBodyChunk, resizeImages, resizeTables, useBackground);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationConverterMail {\n");
    sb.append("    adjustFonts: ").append(toIndentedString(adjustFonts)).append("\n");
    sb.append("    attachmentMode: ").append(toIndentedString(attachmentMode)).append("\n");
    sb.append("    downloadImages: ").append(toIndentedString(downloadImages)).append("\n");
    sb.append("    ignoreMissingBodyChunk: ").append(toIndentedString(ignoreMissingBodyChunk)).append("\n");
    sb.append("    resizeImages: ").append(toIndentedString(resizeImages)).append("\n");
    sb.append("    resizeTables: ").append(toIndentedString(resizeTables)).append("\n");
    sb.append("    useBackground: ").append(toIndentedString(useBackground)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
