/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to convert a PDF document to PDF/A.
 */
@Schema(description = "Used to convert a PDF document to PDF/A.")
@JsonPropertyOrder({
  OperationConvertPdfa.JSON_PROPERTY_AUTO_TAGGING,
  OperationConvertPdfa.JSON_PROPERTY_ERROR_CORRECTION,
  OperationConvertPdfa.JSON_PROPERTY_ERROR_REPORT,
  OperationConvertPdfa.JSON_PROPERTY_IMAGE_QUALITY,
  OperationConvertPdfa.JSON_PROPERTY_LEVEL,
  OperationConvertPdfa.JSON_PROPERTY_SUCCESS_REPORT,
  OperationConvertPdfa.JSON_PROPERTY_ZUGFERD
})
@JsonTypeName("Operation_ConvertPdfa")

public class OperationConvertPdfa {
  public static final String JSON_PROPERTY_AUTO_TAGGING = "autoTagging";
  private Boolean autoTagging = false;

  public static final String JSON_PROPERTY_ERROR_CORRECTION = "errorCorrection";
  private OperationPdfaErrorCorrection errorCorrection;

  /**
   * This parameter is used to define whether and in which format the XML report for a failed conversion will be returned.  *   none &#x3D; An XML report will not be returned *   message &#x3D; The XML report will be returned as part of the error message *   file &#x3D; The XML report will be saved in a file
   */
  public enum ErrorReportEnum {
    NONE("none"),
    
    FILE("file"),
    
    MESSAGE("message");

    private String value;

    ErrorReportEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ErrorReportEnum fromValue(String value) {
      for (ErrorReportEnum b : ErrorReportEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ERROR_REPORT = "errorReport";
  private ErrorReportEnum errorReport = ErrorReportEnum.NONE;

  public static final String JSON_PROPERTY_IMAGE_QUALITY = "imageQuality";
  private Integer imageQuality = 75;

  /**
   * Specifies the compliance level when creating or validating PDF/A documents (as specified in ISO 19005).
   */
  public enum LevelEnum {
    _1A("1a"),
    
    _1B("1b"),
    
    _2A("2a"),
    
    _2B("2b"),
    
    _2U("2u"),
    
    _3A("3a"),
    
    _3B("3b"),
    
    _3U("3u");

    private String value;

    LevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LevelEnum fromValue(String value) {
      for (LevelEnum b : LevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LEVEL = "level";
  private LevelEnum level = LevelEnum._3B;

  /**
   * This parameter is used to define whether and in which format the XML report for a successful conversion will be returned.  *   none &#x3D; An XML report will not be returned *   linked &#x3D; The XML report will be appended at the end of the PDF/A document. *   zip &#x3D; The PDF/A document and the XML report will be packaged together in a ZIP archive.  **Tip:** The format of the document generated with \&quot;errorReport\&quot; and \&quot;successReport\&quot; is described by the http://schema.webpdf.de/1.0/report/pdfa.xsd schema.
   */
  public enum SuccessReportEnum {
    NONE("none"),
    
    ZIP("zip"),
    
    LINKED("linked");

    private String value;

    SuccessReportEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SuccessReportEnum fromValue(String value) {
      for (SuccessReportEnum b : SuccessReportEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUCCESS_REPORT = "successReport";
  private SuccessReportEnum successReport = SuccessReportEnum.NONE;

  public static final String JSON_PROPERTY_ZUGFERD = "zugferd";
  private OperationZugferd zugferd;

  public OperationConvertPdfa() {
  }

  public OperationConvertPdfa autoTagging(Boolean autoTagging) {
    
    this.autoTagging = autoTagging;
    return this;
  }

  /**
   * In order to convert a document to conformity levels PDF/A 1a-3a, the entire document must have appropriate structure information (tags). If auto tagging is enabled, the corresponding structure information (in the form of page tags) will be generated automatically before the actual conversion.
   * @return autoTagging
   **/
  @Nullable
  @Schema(name = "In order to convert a document to conformity levels PDF/A 1a-3a, the entire document must have appropriate structure information (tags). If auto tagging is enabled, the corresponding structure information (in the form of page tags) will be generated automatically before the actual conversion.")
  @JsonProperty(JSON_PROPERTY_AUTO_TAGGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAutoTagging() {
    return autoTagging;
  }


  @JsonProperty(JSON_PROPERTY_AUTO_TAGGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoTagging(Boolean autoTagging) {
    this.autoTagging = autoTagging;
  }


  public OperationConvertPdfa errorCorrection(OperationPdfaErrorCorrection errorCorrection) {
    
    this.errorCorrection = errorCorrection;
    return this;
  }

  /**
   * Get errorCorrection
   * @return errorCorrection
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ERROR_CORRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationPdfaErrorCorrection getErrorCorrection() {
    return errorCorrection;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_CORRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCorrection(OperationPdfaErrorCorrection errorCorrection) {
    this.errorCorrection = errorCorrection;
  }


  public OperationConvertPdfa errorReport(ErrorReportEnum errorReport) {
    
    this.errorReport = errorReport;
    return this;
  }

  /**
   * This parameter is used to define whether and in which format the XML report for a failed conversion will be returned.  *   none &#x3D; An XML report will not be returned *   message &#x3D; The XML report will be returned as part of the error message *   file &#x3D; The XML report will be saved in a file
   * @return errorReport
   **/
  @Nullable
  @Schema(name = "This parameter is used to define whether and in which format the XML report for a failed conversion will be returned.  *   none = An XML report will not be returned *   message = The XML report will be returned as part of the error message *   file = The XML report will be saved in a file")
  @JsonProperty(JSON_PROPERTY_ERROR_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ErrorReportEnum getErrorReport() {
    return errorReport;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorReport(ErrorReportEnum errorReport) {
    this.errorReport = errorReport;
  }


  public OperationConvertPdfa imageQuality(Integer imageQuality) {
    
    this.imageQuality = imageQuality;
    return this;
  }

  /**
   * The quality for images which must be transformed during the conversion because they use a compression which is not allowed (e.g. JPX is not allowed in PDF/A-1) is defined using this parameter. Values in a range from 1 to 100 are allowed whereby a higher value means better quality, but also larger PDF documents.
   * minimum: 0
   * maximum: 100
   * @return imageQuality
   **/
  @Nullable
  @Schema(name = "The quality for images which must be transformed during the conversion because they use a compression which is not allowed (e.g. JPX is not allowed in PDF/A-1) is defined using this parameter. Values in a range from 1 to 100 are allowed whereby a higher value means better quality, but also larger PDF documents.")
  @JsonProperty(JSON_PROPERTY_IMAGE_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getImageQuality() {
    return imageQuality;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageQuality(Integer imageQuality) {
    this.imageQuality = imageQuality;
  }


  public OperationConvertPdfa level(LevelEnum level) {
    
    this.level = level;
    return this;
  }

  /**
   * Specifies the compliance level when creating or validating PDF/A documents (as specified in ISO 19005).
   * @return level
   **/
  @Nullable
  @Schema(name = "Specifies the compliance level when creating or validating PDF/A documents (as specified in ISO 19005).")
  @JsonProperty(JSON_PROPERTY_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LevelEnum getLevel() {
    return level;
  }


  @JsonProperty(JSON_PROPERTY_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLevel(LevelEnum level) {
    this.level = level;
  }


  public OperationConvertPdfa successReport(SuccessReportEnum successReport) {
    
    this.successReport = successReport;
    return this;
  }

  /**
   * This parameter is used to define whether and in which format the XML report for a successful conversion will be returned.  *   none &#x3D; An XML report will not be returned *   linked &#x3D; The XML report will be appended at the end of the PDF/A document. *   zip &#x3D; The PDF/A document and the XML report will be packaged together in a ZIP archive.  **Tip:** The format of the document generated with \&quot;errorReport\&quot; and \&quot;successReport\&quot; is described by the http://schema.webpdf.de/1.0/report/pdfa.xsd schema.
   * @return successReport
   **/
  @Nullable
  @Schema(name = "This parameter is used to define whether and in which format the XML report for a successful conversion will be returned.  *   none = An XML report will not be returned *   linked = The XML report will be appended at the end of the PDF/A document. *   zip = The PDF/A document and the XML report will be packaged together in a ZIP archive.  **Tip:** The format of the document generated with \"errorReport\" and \"successReport\" is described by the http://schema.webpdf.de/1.0/report/pdfa.xsd schema.")
  @JsonProperty(JSON_PROPERTY_SUCCESS_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SuccessReportEnum getSuccessReport() {
    return successReport;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS_REPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSuccessReport(SuccessReportEnum successReport) {
    this.successReport = successReport;
  }


  public OperationConvertPdfa zugferd(OperationZugferd zugferd) {
    
    this.zugferd = zugferd;
    return this;
  }

  /**
   * Get zugferd
   * @return zugferd
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ZUGFERD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationZugferd getZugferd() {
    return zugferd;
  }


  @JsonProperty(JSON_PROPERTY_ZUGFERD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZugferd(OperationZugferd zugferd) {
    this.zugferd = zugferd;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationConvertPdfa operationConvertPdfa = (OperationConvertPdfa) o;
    return Objects.equals(this.autoTagging, operationConvertPdfa.autoTagging) &&
        Objects.equals(this.errorCorrection, operationConvertPdfa.errorCorrection) &&
        Objects.equals(this.errorReport, operationConvertPdfa.errorReport) &&
        Objects.equals(this.imageQuality, operationConvertPdfa.imageQuality) &&
        Objects.equals(this.level, operationConvertPdfa.level) &&
        Objects.equals(this.successReport, operationConvertPdfa.successReport) &&
        Objects.equals(this.zugferd, operationConvertPdfa.zugferd);
  }

  @Override
  public int hashCode() {
    return Objects.hash(autoTagging, errorCorrection, errorReport, imageQuality, level, successReport, zugferd);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationConvertPdfa {\n");
    sb.append("    autoTagging: ").append(toIndentedString(autoTagging)).append("\n");
    sb.append("    errorCorrection: ").append(toIndentedString(errorCorrection)).append("\n");
    sb.append("    errorReport: ").append(toIndentedString(errorReport)).append("\n");
    sb.append("    imageQuality: ").append(toIndentedString(imageQuality)).append("\n");
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    successReport: ").append(toIndentedString(successReport)).append("\n");
    sb.append("    zugferd: ").append(toIndentedString(zugferd)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
