/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The base type for all Toolbox webservice operations.
 */
@Schema(description = "The base type for all Toolbox webservice operations.")
@JsonPropertyOrder({
  OperationBaseToolbox.JSON_PROPERTY_ANNOTATION,
  OperationBaseToolbox.JSON_PROPERTY_ATTACHMENT,
  OperationBaseToolbox.JSON_PROPERTY_DELETE,
  OperationBaseToolbox.JSON_PROPERTY_DESCRIPTION,
  OperationBaseToolbox.JSON_PROPERTY_EXTRACTION,
  OperationBaseToolbox.JSON_PROPERTY_FORMS,
  OperationBaseToolbox.JSON_PROPERTY_IMAGE,
  OperationBaseToolbox.JSON_PROPERTY_MERGE,
  OperationBaseToolbox.JSON_PROPERTY_MOVE,
  OperationBaseToolbox.JSON_PROPERTY_OPTIONS,
  OperationBaseToolbox.JSON_PROPERTY_PRINT,
  OperationBaseToolbox.JSON_PROPERTY_ROTATE,
  OperationBaseToolbox.JSON_PROPERTY_SECURITY,
  OperationBaseToolbox.JSON_PROPERTY_SPLIT,
  OperationBaseToolbox.JSON_PROPERTY_WATERMARK,
  OperationBaseToolbox.JSON_PROPERTY_XMP,
  OperationBaseToolbox.JSON_PROPERTY_OUTLINE,
  OperationBaseToolbox.JSON_PROPERTY_REDACT,
  OperationBaseToolbox.JSON_PROPERTY_PORTFOLIO,
  OperationBaseToolbox.JSON_PROPERTY_SCALE,
  OperationBaseToolbox.JSON_PROPERTY_COMPRESS,
  OperationBaseToolbox.JSON_PROPERTY_TRANSCRIBE
})
@JsonTypeName("Operation_BaseToolbox")

public class OperationBaseToolbox {
  public static final String JSON_PROPERTY_ANNOTATION = "annotation";
  private OperationToolboxAnnotationAnnotation annotation;

  public static final String JSON_PROPERTY_ATTACHMENT = "attachment";
  private OperationToolboxAttachmentAttachment attachment;

  public static final String JSON_PROPERTY_DELETE = "delete";
  private OperationToolboxDeleteDelete delete;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private OperationToolboxDescriptionDescription description;

  public static final String JSON_PROPERTY_EXTRACTION = "extraction";
  private OperationToolboxExtractionExtraction extraction;

  public static final String JSON_PROPERTY_FORMS = "forms";
  private OperationToolboxFormsForms forms;

  public static final String JSON_PROPERTY_IMAGE = "image";
  private OperationToolboxImageImage image;

  public static final String JSON_PROPERTY_MERGE = "merge";
  private OperationToolboxMergeMerge merge;

  public static final String JSON_PROPERTY_MOVE = "move";
  private OperationToolboxMoveMove move;

  public static final String JSON_PROPERTY_OPTIONS = "options";
  private OperationToolboxOptionsOptions options;

  public static final String JSON_PROPERTY_PRINT = "print";
  private OperationToolboxPrintPrint print;

  public static final String JSON_PROPERTY_ROTATE = "rotate";
  private OperationToolboxRotateRotate rotate;

  public static final String JSON_PROPERTY_SECURITY = "security";
  private OperationToolboxSecuritySecurity security;

  public static final String JSON_PROPERTY_SPLIT = "split";
  private OperationToolboxSplitSplit split;

  public static final String JSON_PROPERTY_WATERMARK = "watermark";
  private OperationToolboxWatermarkWatermark watermark;

  public static final String JSON_PROPERTY_XMP = "xmp";
  private OperationToolboxXmpXmp xmp;

  public static final String JSON_PROPERTY_OUTLINE = "outline";
  private OperationToolboxOutlineOutline outline;

  public static final String JSON_PROPERTY_REDACT = "redact";
  private OperationToolboxRedactRedact redact;

  public static final String JSON_PROPERTY_PORTFOLIO = "portfolio";
  private OperationToolboxPortfolioPortfolio portfolio;

  public static final String JSON_PROPERTY_SCALE = "scale";
  private OperationToolboxScaleScale scale;

  public static final String JSON_PROPERTY_COMPRESS = "compress";
  private OperationToolboxCompressCompress compress;

  public static final String JSON_PROPERTY_TRANSCRIBE = "transcribe";
  private OperationToolboxTranscribeTranscribe transcribe;

  public OperationBaseToolbox() {
  }

  public OperationBaseToolbox annotation(OperationToolboxAnnotationAnnotation annotation) {
    
    this.annotation = annotation;
    return this;
  }

  /**
   * Get annotation
   * @return annotation
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ANNOTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxAnnotationAnnotation getAnnotation() {
    return annotation;
  }


  @JsonProperty(JSON_PROPERTY_ANNOTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnotation(OperationToolboxAnnotationAnnotation annotation) {
    this.annotation = annotation;
  }


  public OperationBaseToolbox attachment(OperationToolboxAttachmentAttachment attachment) {
    
    this.attachment = attachment;
    return this;
  }

  /**
   * Get attachment
   * @return attachment
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ATTACHMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxAttachmentAttachment getAttachment() {
    return attachment;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachment(OperationToolboxAttachmentAttachment attachment) {
    this.attachment = attachment;
  }


  public OperationBaseToolbox delete(OperationToolboxDeleteDelete delete) {
    
    this.delete = delete;
    return this;
  }

  /**
   * Get delete
   * @return delete
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_DELETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxDeleteDelete getDelete() {
    return delete;
  }


  @JsonProperty(JSON_PROPERTY_DELETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDelete(OperationToolboxDeleteDelete delete) {
    this.delete = delete;
  }


  public OperationBaseToolbox description(OperationToolboxDescriptionDescription description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxDescriptionDescription getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(OperationToolboxDescriptionDescription description) {
    this.description = description;
  }


  public OperationBaseToolbox extraction(OperationToolboxExtractionExtraction extraction) {
    
    this.extraction = extraction;
    return this;
  }

  /**
   * Get extraction
   * @return extraction
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_EXTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxExtractionExtraction getExtraction() {
    return extraction;
  }


  @JsonProperty(JSON_PROPERTY_EXTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraction(OperationToolboxExtractionExtraction extraction) {
    this.extraction = extraction;
  }


  public OperationBaseToolbox forms(OperationToolboxFormsForms forms) {
    
    this.forms = forms;
    return this;
  }

  /**
   * Get forms
   * @return forms
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FORMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxFormsForms getForms() {
    return forms;
  }


  @JsonProperty(JSON_PROPERTY_FORMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForms(OperationToolboxFormsForms forms) {
    this.forms = forms;
  }


  public OperationBaseToolbox image(OperationToolboxImageImage image) {
    
    this.image = image;
    return this;
  }

  /**
   * Get image
   * @return image
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxImageImage getImage() {
    return image;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage(OperationToolboxImageImage image) {
    this.image = image;
  }


  public OperationBaseToolbox merge(OperationToolboxMergeMerge merge) {
    
    this.merge = merge;
    return this;
  }

  /**
   * Get merge
   * @return merge
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MERGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxMergeMerge getMerge() {
    return merge;
  }


  @JsonProperty(JSON_PROPERTY_MERGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerge(OperationToolboxMergeMerge merge) {
    this.merge = merge;
  }


  public OperationBaseToolbox move(OperationToolboxMoveMove move) {
    
    this.move = move;
    return this;
  }

  /**
   * Get move
   * @return move
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MOVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxMoveMove getMove() {
    return move;
  }


  @JsonProperty(JSON_PROPERTY_MOVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMove(OperationToolboxMoveMove move) {
    this.move = move;
  }


  public OperationBaseToolbox options(OperationToolboxOptionsOptions options) {
    
    this.options = options;
    return this;
  }

  /**
   * Get options
   * @return options
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxOptionsOptions getOptions() {
    return options;
  }


  @JsonProperty(JSON_PROPERTY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOptions(OperationToolboxOptionsOptions options) {
    this.options = options;
  }


  public OperationBaseToolbox print(OperationToolboxPrintPrint print) {
    
    this.print = print;
    return this;
  }

  /**
   * Get print
   * @return print
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxPrintPrint getPrint() {
    return print;
  }


  @JsonProperty(JSON_PROPERTY_PRINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrint(OperationToolboxPrintPrint print) {
    this.print = print;
  }


  public OperationBaseToolbox rotate(OperationToolboxRotateRotate rotate) {
    
    this.rotate = rotate;
    return this;
  }

  /**
   * Get rotate
   * @return rotate
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ROTATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxRotateRotate getRotate() {
    return rotate;
  }


  @JsonProperty(JSON_PROPERTY_ROTATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotate(OperationToolboxRotateRotate rotate) {
    this.rotate = rotate;
  }


  public OperationBaseToolbox security(OperationToolboxSecuritySecurity security) {
    
    this.security = security;
    return this;
  }

  /**
   * Get security
   * @return security
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SECURITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxSecuritySecurity getSecurity() {
    return security;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurity(OperationToolboxSecuritySecurity security) {
    this.security = security;
  }


  public OperationBaseToolbox split(OperationToolboxSplitSplit split) {
    
    this.split = split;
    return this;
  }

  /**
   * Get split
   * @return split
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SPLIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxSplitSplit getSplit() {
    return split;
  }


  @JsonProperty(JSON_PROPERTY_SPLIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplit(OperationToolboxSplitSplit split) {
    this.split = split;
  }


  public OperationBaseToolbox watermark(OperationToolboxWatermarkWatermark watermark) {
    
    this.watermark = watermark;
    return this;
  }

  /**
   * Get watermark
   * @return watermark
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_WATERMARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxWatermarkWatermark getWatermark() {
    return watermark;
  }


  @JsonProperty(JSON_PROPERTY_WATERMARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWatermark(OperationToolboxWatermarkWatermark watermark) {
    this.watermark = watermark;
  }


  public OperationBaseToolbox xmp(OperationToolboxXmpXmp xmp) {
    
    this.xmp = xmp;
    return this;
  }

  /**
   * Get xmp
   * @return xmp
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_XMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxXmpXmp getXmp() {
    return xmp;
  }


  @JsonProperty(JSON_PROPERTY_XMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setXmp(OperationToolboxXmpXmp xmp) {
    this.xmp = xmp;
  }


  public OperationBaseToolbox outline(OperationToolboxOutlineOutline outline) {
    
    this.outline = outline;
    return this;
  }

  /**
   * Get outline
   * @return outline
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_OUTLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxOutlineOutline getOutline() {
    return outline;
  }


  @JsonProperty(JSON_PROPERTY_OUTLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutline(OperationToolboxOutlineOutline outline) {
    this.outline = outline;
  }


  public OperationBaseToolbox redact(OperationToolboxRedactRedact redact) {
    
    this.redact = redact;
    return this;
  }

  /**
   * Get redact
   * @return redact
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_REDACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxRedactRedact getRedact() {
    return redact;
  }


  @JsonProperty(JSON_PROPERTY_REDACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedact(OperationToolboxRedactRedact redact) {
    this.redact = redact;
  }


  public OperationBaseToolbox portfolio(OperationToolboxPortfolioPortfolio portfolio) {
    
    this.portfolio = portfolio;
    return this;
  }

  /**
   * Get portfolio
   * @return portfolio
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PORTFOLIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxPortfolioPortfolio getPortfolio() {
    return portfolio;
  }


  @JsonProperty(JSON_PROPERTY_PORTFOLIO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPortfolio(OperationToolboxPortfolioPortfolio portfolio) {
    this.portfolio = portfolio;
  }


  public OperationBaseToolbox scale(OperationToolboxScaleScale scale) {
    
    this.scale = scale;
    return this;
  }

  /**
   * Get scale
   * @return scale
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxScaleScale getScale() {
    return scale;
  }


  @JsonProperty(JSON_PROPERTY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScale(OperationToolboxScaleScale scale) {
    this.scale = scale;
  }


  public OperationBaseToolbox compress(OperationToolboxCompressCompress compress) {
    
    this.compress = compress;
    return this;
  }

  /**
   * Get compress
   * @return compress
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_COMPRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxCompressCompress getCompress() {
    return compress;
  }


  @JsonProperty(JSON_PROPERTY_COMPRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompress(OperationToolboxCompressCompress compress) {
    this.compress = compress;
  }


  public OperationBaseToolbox transcribe(OperationToolboxTranscribeTranscribe transcribe) {
    
    this.transcribe = transcribe;
    return this;
  }

  /**
   * Get transcribe
   * @return transcribe
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TRANSCRIBE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationToolboxTranscribeTranscribe getTranscribe() {
    return transcribe;
  }


  @JsonProperty(JSON_PROPERTY_TRANSCRIBE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTranscribe(OperationToolboxTranscribeTranscribe transcribe) {
    this.transcribe = transcribe;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationBaseToolbox operationBaseToolbox = (OperationBaseToolbox) o;
    return Objects.equals(this.annotation, operationBaseToolbox.annotation) &&
        Objects.equals(this.attachment, operationBaseToolbox.attachment) &&
        Objects.equals(this.delete, operationBaseToolbox.delete) &&
        Objects.equals(this.description, operationBaseToolbox.description) &&
        Objects.equals(this.extraction, operationBaseToolbox.extraction) &&
        Objects.equals(this.forms, operationBaseToolbox.forms) &&
        Objects.equals(this.image, operationBaseToolbox.image) &&
        Objects.equals(this.merge, operationBaseToolbox.merge) &&
        Objects.equals(this.move, operationBaseToolbox.move) &&
        Objects.equals(this.options, operationBaseToolbox.options) &&
        Objects.equals(this.print, operationBaseToolbox.print) &&
        Objects.equals(this.rotate, operationBaseToolbox.rotate) &&
        Objects.equals(this.security, operationBaseToolbox.security) &&
        Objects.equals(this.split, operationBaseToolbox.split) &&
        Objects.equals(this.watermark, operationBaseToolbox.watermark) &&
        Objects.equals(this.xmp, operationBaseToolbox.xmp) &&
        Objects.equals(this.outline, operationBaseToolbox.outline) &&
        Objects.equals(this.redact, operationBaseToolbox.redact) &&
        Objects.equals(this.portfolio, operationBaseToolbox.portfolio) &&
        Objects.equals(this.scale, operationBaseToolbox.scale) &&
        Objects.equals(this.compress, operationBaseToolbox.compress) &&
        Objects.equals(this.transcribe, operationBaseToolbox.transcribe);
  }

  @Override
  public int hashCode() {
    return Objects.hash(annotation, attachment, delete, description, extraction, forms, image, merge, move, options, print, rotate, security, split, watermark, xmp, outline, redact, portfolio, scale, compress, transcribe);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationBaseToolbox {\n");
    sb.append("    annotation: ").append(toIndentedString(annotation)).append("\n");
    sb.append("    attachment: ").append(toIndentedString(attachment)).append("\n");
    sb.append("    delete: ").append(toIndentedString(delete)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    extraction: ").append(toIndentedString(extraction)).append("\n");
    sb.append("    forms: ").append(toIndentedString(forms)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    merge: ").append(toIndentedString(merge)).append("\n");
    sb.append("    move: ").append(toIndentedString(move)).append("\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("    print: ").append(toIndentedString(print)).append("\n");
    sb.append("    rotate: ").append(toIndentedString(rotate)).append("\n");
    sb.append("    security: ").append(toIndentedString(security)).append("\n");
    sb.append("    split: ").append(toIndentedString(split)).append("\n");
    sb.append("    watermark: ").append(toIndentedString(watermark)).append("\n");
    sb.append("    xmp: ").append(toIndentedString(xmp)).append("\n");
    sb.append("    outline: ").append(toIndentedString(outline)).append("\n");
    sb.append("    redact: ").append(toIndentedString(redact)).append("\n");
    sb.append("    portfolio: ").append(toIndentedString(portfolio)).append("\n");
    sb.append("    scale: ").append(toIndentedString(scale)).append("\n");
    sb.append("    compress: ").append(toIndentedString(compress)).append("\n");
    sb.append("    transcribe: ").append(toIndentedString(transcribe)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
