/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to add a new signature to the PDF document.
 */
@Schema(description = "Used to add a new signature to the PDF document.")
@JsonPropertyOrder({
  OperationAddSignature.JSON_PROPERTY_APPEARANCE,
  OperationAddSignature.JSON_PROPERTY_APPEND_SIGNATURE,
  OperationAddSignature.JSON_PROPERTY_CERTIFICATION_LEVEL,
  OperationAddSignature.JSON_PROPERTY_CONTACT,
  OperationAddSignature.JSON_PROPERTY_FIELD_NAME,
  OperationAddSignature.JSON_PROPERTY_KEY_NAME,
  OperationAddSignature.JSON_PROPERTY_KEY_PASSWORD,
  OperationAddSignature.JSON_PROPERTY_LOCATION,
  OperationAddSignature.JSON_PROPERTY_REASON,
  OperationAddSignature.JSON_PROPERTY_SIGNER
})
@JsonTypeName("Operation_AddSignature")

public class OperationAddSignature {
  public static final String JSON_PROPERTY_APPEARANCE = "appearance";
  private OperationAppearanceAdd appearance;

  public static final String JSON_PROPERTY_APPEND_SIGNATURE = "appendSignature";
  private Boolean appendSignature = false;

  /**
   * This parameter defines the level of the signature.  *   none &#x3D; Sign, but do not certify, the document, i.e., additional signatures and changes will be allowed. *   noChanges &#x3D; Certify the document and do not allow any additional changes anymore. *   formFillingAndSignatures &#x3D; Certify the document, but allow for fields to be filled out. *   formFillingAndSignaturesAndAnnotations &#x3D; Certify the document, but allow for fields to be filled out and annotations to be added.
   */
  public enum CertificationLevelEnum {
    NONE("none"),
    
    NOCHANGES("noChanges"),
    
    FORMFILLINGANDSIGNATURES("formFillingAndSignatures"),
    
    FORMFILLINGANDSIGNATURESANDANNOTATIONS("formFillingAndSignaturesAndAnnotations");

    private String value;

    CertificationLevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CertificationLevelEnum fromValue(String value) {
      for (CertificationLevelEnum b : CertificationLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CERTIFICATION_LEVEL = "certificationLevel";
  private CertificationLevelEnum certificationLevel = CertificationLevelEnum.NOCHANGES;

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private String contact = "";

  public static final String JSON_PROPERTY_FIELD_NAME = "fieldName";
  private String fieldName = "Signature1";

  public static final String JSON_PROPERTY_KEY_NAME = "keyName";
  private String keyName = "";

  public static final String JSON_PROPERTY_KEY_PASSWORD = "keyPassword";
  private String keyPassword = "";

  public static final String JSON_PROPERTY_LOCATION = "location";
  private String location = "";

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason = "";

  public static final String JSON_PROPERTY_SIGNER = "signer";
  private OperationSignerAdd signer;

  public OperationAddSignature() {
  }

  public OperationAddSignature appearance(OperationAppearanceAdd appearance) {
    
    this.appearance = appearance;
    return this;
  }

  /**
   * Get appearance
   * @return appearance
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_APPEARANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationAppearanceAdd getAppearance() {
    return appearance;
  }


  @JsonProperty(JSON_PROPERTY_APPEARANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppearance(OperationAppearanceAdd appearance) {
    this.appearance = appearance;
  }


  public OperationAddSignature appendSignature(Boolean appendSignature) {
    
    this.appendSignature = appendSignature;
    return this;
  }

  /**
   * **Deprecated:** Usage of this parameter is discouraged, as it is no longer in use.
   * @return appendSignature
   **/
  @Nullable
  @Schema(name = "**Deprecated:** Usage of this parameter is discouraged, as it is no longer in use.")
  @JsonProperty(JSON_PROPERTY_APPEND_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAppendSignature() {
    return appendSignature;
  }


  @JsonProperty(JSON_PROPERTY_APPEND_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppendSignature(Boolean appendSignature) {
    this.appendSignature = appendSignature;
  }


  public OperationAddSignature certificationLevel(CertificationLevelEnum certificationLevel) {
    
    this.certificationLevel = certificationLevel;
    return this;
  }

  /**
   * This parameter defines the level of the signature.  *   none &#x3D; Sign, but do not certify, the document, i.e., additional signatures and changes will be allowed. *   noChanges &#x3D; Certify the document and do not allow any additional changes anymore. *   formFillingAndSignatures &#x3D; Certify the document, but allow for fields to be filled out. *   formFillingAndSignaturesAndAnnotations &#x3D; Certify the document, but allow for fields to be filled out and annotations to be added.
   * @return certificationLevel
   **/
  @Nullable
  @Schema(name = "This parameter defines the level of the signature.  *   none = Sign, but do not certify, the document, i.e., additional signatures and changes will be allowed. *   noChanges = Certify the document and do not allow any additional changes anymore. *   formFillingAndSignatures = Certify the document, but allow for fields to be filled out. *   formFillingAndSignaturesAndAnnotations = Certify the document, but allow for fields to be filled out and annotations to be added.")
  @JsonProperty(JSON_PROPERTY_CERTIFICATION_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CertificationLevelEnum getCertificationLevel() {
    return certificationLevel;
  }


  @JsonProperty(JSON_PROPERTY_CERTIFICATION_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCertificationLevel(CertificationLevelEnum certificationLevel) {
    this.certificationLevel = certificationLevel;
  }


  public OperationAddSignature contact(String contact) {
    
    this.contact = contact;
    return this;
  }

  /**
   * Specifies the name of the person signing the document.
   * @return contact
   **/
  @Nullable
  @Schema(name = "Specifies the name of the person signing the document.")
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContact(String contact) {
    this.contact = contact;
  }


  public OperationAddSignature fieldName(String fieldName) {
    
    this.fieldName = fieldName;
    return this;
  }

  /**
   * Defines the name of the field (in the document) in which the signature will be saved. If a field name that is not unique is declared, then a unique name will be automatically created.
   * @return fieldName
   **/
  @Nullable
  @Schema(name = "Defines the name of the field (in the document) in which the signature will be saved. If a field name that is not unique is declared, then a unique name will be automatically created.")
  @JsonProperty(JSON_PROPERTY_FIELD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFieldName() {
    return fieldName;
  }


  @JsonProperty(JSON_PROPERTY_FIELD_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }


  public OperationAddSignature keyName(String keyName) {
    
    this.keyName = keyName;
    return this;
  }

  /**
   * Defines the name of the key (alias) that is to be used to sign the document. This option overwrites the server&#39;s configuration setting. Additional information can be found in the \&quot;Keystore\&quot; chapter.
   * @return keyName
   **/
  @Nullable
  @Schema(name = "Defines the name of the key (alias) that is to be used to sign the document. This option overwrites the server's configuration setting. Additional information can be found in the \"Keystore\" chapter.")
  @JsonProperty(JSON_PROPERTY_KEY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getKeyName() {
    return keyName;
  }


  @JsonProperty(JSON_PROPERTY_KEY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeyName(String keyName) {
    this.keyName = keyName;
  }


  public OperationAddSignature keyPassword(String keyPassword) {
    
    this.keyPassword = keyPassword;
    return this;
  }

  /**
   * Used to define the password required in order to access the private key with \&quot;keyName.\&quot; This option overwrites the server&#39;s configuration setting. Additional information can be found in the \&quot;Keystore\&quot; chapter.
   * @return keyPassword
   **/
  @Nullable
  @Schema(name = "Used to define the password required in order to access the private key with \"keyName.\" This option overwrites the server's configuration setting. Additional information can be found in the \"Keystore\" chapter.")
  @JsonProperty(JSON_PROPERTY_KEY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getKeyPassword() {
    return keyPassword;
  }


  @JsonProperty(JSON_PROPERTY_KEY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeyPassword(String keyPassword) {
    this.keyPassword = keyPassword;
  }


  public OperationAddSignature location(String location) {
    
    this.location = location;
    return this;
  }

  /**
   * Specifies the location of the signature.
   * @return location
   **/
  @Nullable
  @Schema(name = "Specifies the location of the signature.")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(String location) {
    this.location = location;
  }


  public OperationAddSignature reason(String reason) {
    
    this.reason = reason;
    return this;
  }

  /**
   * Specifies the reason why the document is being signed.
   * @return reason
   **/
  @Nullable
  @Schema(name = "Specifies the reason why the document is being signed.")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReason() {
    return reason;
  }


  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReason(String reason) {
    this.reason = reason;
  }


  public OperationAddSignature signer(OperationSignerAdd signer) {
    
    this.signer = signer;
    return this;
  }

  /**
   * Get signer
   * @return signer
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SIGNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSignerAdd getSigner() {
    return signer;
  }


  @JsonProperty(JSON_PROPERTY_SIGNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSigner(OperationSignerAdd signer) {
    this.signer = signer;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationAddSignature operationAddSignature = (OperationAddSignature) o;
    return Objects.equals(this.appearance, operationAddSignature.appearance) &&
        Objects.equals(this.appendSignature, operationAddSignature.appendSignature) &&
        Objects.equals(this.certificationLevel, operationAddSignature.certificationLevel) &&
        Objects.equals(this.contact, operationAddSignature.contact) &&
        Objects.equals(this.fieldName, operationAddSignature.fieldName) &&
        Objects.equals(this.keyName, operationAddSignature.keyName) &&
        Objects.equals(this.keyPassword, operationAddSignature.keyPassword) &&
        Objects.equals(this.location, operationAddSignature.location) &&
        Objects.equals(this.reason, operationAddSignature.reason) &&
        Objects.equals(this.signer, operationAddSignature.signer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appearance, appendSignature, certificationLevel, contact, fieldName, keyName, keyPassword, location, reason, signer);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationAddSignature {\n");
    sb.append("    appearance: ").append(toIndentedString(appearance)).append("\n");
    sb.append("    appendSignature: ").append(toIndentedString(appendSignature)).append("\n");
    sb.append("    certificationLevel: ").append(toIndentedString(certificationLevel)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    keyName: ").append(toIndentedString(keyName)).append("\n");
    sb.append("    keyPassword: ").append(toIndentedString(keyPassword)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    signer: ").append(toIndentedString(signer)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
