/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Used to add a new barcode to the document.
 */
@Schema(description = "Used to add a new barcode to the document.")
@JsonPropertyOrder({
  OperationAddBarcode.JSON_PROPERTY_AZTEC,
  OperationAddBarcode.JSON_PROPERTY_CODABAR,
  OperationAddBarcode.JSON_PROPERTY_CODE128,
  OperationAddBarcode.JSON_PROPERTY_CODE39,
  OperationAddBarcode.JSON_PROPERTY_DATAMATRIX,
  OperationAddBarcode.JSON_PROPERTY_EAN13,
  OperationAddBarcode.JSON_PROPERTY_EAN8,
  OperationAddBarcode.JSON_PROPERTY_ITF,
  OperationAddBarcode.JSON_PROPERTY_OUTPUT_FORMAT,
  OperationAddBarcode.JSON_PROPERTY_PDF417,
  OperationAddBarcode.JSON_PROPERTY_QRCODE,
  OperationAddBarcode.JSON_PROPERTY_QRSWISS,
  OperationAddBarcode.JSON_PROPERTY_UPCA
})
@JsonTypeName("Operation_AddBarcode")

public class OperationAddBarcode {
  public static final String JSON_PROPERTY_AZTEC = "aztec";
  private List<OperationAztecBarcode> aztec = null;

  public static final String JSON_PROPERTY_CODABAR = "codabar";
  private List<OperationCodabarBarcode> codabar = null;

  public static final String JSON_PROPERTY_CODE128 = "code128";
  private List<OperationCode128Barcode> code128 = null;

  public static final String JSON_PROPERTY_CODE39 = "code39";
  private List<OperationCode39Barcode> code39 = null;

  public static final String JSON_PROPERTY_DATAMATRIX = "datamatrix";
  private List<OperationDataMatrixBarcode> datamatrix = null;

  public static final String JSON_PROPERTY_EAN13 = "ean13";
  private List<OperationEan13Barcode> ean13 = null;

  public static final String JSON_PROPERTY_EAN8 = "ean8";
  private List<OperationEan8Barcode> ean8 = null;

  public static final String JSON_PROPERTY_ITF = "itf";
  private List<OperationItfBarcode> itf = null;

  /**
   * Defines the output format for the barcode generation. The resulting document will be created by this webservice, where selected image formats will completly ignore a possibly given PDF source document and will only contain the barcode image.  **Important:** This parameter is for internal use only. Please only set this value to anything other than \&quot;pdf\&quot;, if you are really sure that you need to do so.
   */
  public enum OutputFormatEnum {
    PDF("pdf"),
    
    BMP("bmp"),
    
    JPG("jpg"),
    
    PNG("png"),
    
    TIF("tif");

    private String value;

    OutputFormatEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OutputFormatEnum fromValue(String value) {
      for (OutputFormatEnum b : OutputFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OUTPUT_FORMAT = "outputFormat";
  private OutputFormatEnum outputFormat = OutputFormatEnum.PDF;

  public static final String JSON_PROPERTY_PDF417 = "pdf417";
  private List<OperationPdf417Barcode> pdf417 = null;

  public static final String JSON_PROPERTY_QRCODE = "qrcode";
  private List<OperationQrBarcode> qrcode = null;

  public static final String JSON_PROPERTY_QRSWISS = "qrswiss";
  private List<OperationQrSwissPaymentBarcode> qrswiss = null;

  public static final String JSON_PROPERTY_UPCA = "upca";
  private List<OperationUpcaBarcode> upca = null;

  public OperationAddBarcode() {
  }

  public OperationAddBarcode aztec(List<OperationAztecBarcode> aztec) {
    
    this.aztec = aztec;
    return this;
  }

  public OperationAddBarcode addAztecItem(OperationAztecBarcode aztecItem) {
    if (this.aztec == null) {
      this.aztec = new ArrayList<>();
    }
    this.aztec.add(aztecItem);
    return this;
  }

  /**
   * Get aztec
   * @return aztec
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_AZTEC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationAztecBarcode> getAztec() {
    return aztec;
  }


  @JsonProperty(JSON_PROPERTY_AZTEC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAztec(List<OperationAztecBarcode> aztec) {
    this.aztec = aztec;
  }


  public OperationAddBarcode codabar(List<OperationCodabarBarcode> codabar) {
    
    this.codabar = codabar;
    return this;
  }

  public OperationAddBarcode addCodabarItem(OperationCodabarBarcode codabarItem) {
    if (this.codabar == null) {
      this.codabar = new ArrayList<>();
    }
    this.codabar.add(codabarItem);
    return this;
  }

  /**
   * Get codabar
   * @return codabar
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CODABAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationCodabarBarcode> getCodabar() {
    return codabar;
  }


  @JsonProperty(JSON_PROPERTY_CODABAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCodabar(List<OperationCodabarBarcode> codabar) {
    this.codabar = codabar;
  }


  public OperationAddBarcode code128(List<OperationCode128Barcode> code128) {
    
    this.code128 = code128;
    return this;
  }

  public OperationAddBarcode addCode128Item(OperationCode128Barcode code128Item) {
    if (this.code128 == null) {
      this.code128 = new ArrayList<>();
    }
    this.code128.add(code128Item);
    return this;
  }

  /**
   * Get code128
   * @return code128
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CODE128)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationCode128Barcode> getCode128() {
    return code128;
  }


  @JsonProperty(JSON_PROPERTY_CODE128)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode128(List<OperationCode128Barcode> code128) {
    this.code128 = code128;
  }


  public OperationAddBarcode code39(List<OperationCode39Barcode> code39) {
    
    this.code39 = code39;
    return this;
  }

  public OperationAddBarcode addCode39Item(OperationCode39Barcode code39Item) {
    if (this.code39 == null) {
      this.code39 = new ArrayList<>();
    }
    this.code39.add(code39Item);
    return this;
  }

  /**
   * Get code39
   * @return code39
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CODE39)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationCode39Barcode> getCode39() {
    return code39;
  }


  @JsonProperty(JSON_PROPERTY_CODE39)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode39(List<OperationCode39Barcode> code39) {
    this.code39 = code39;
  }


  public OperationAddBarcode datamatrix(List<OperationDataMatrixBarcode> datamatrix) {
    
    this.datamatrix = datamatrix;
    return this;
  }

  public OperationAddBarcode addDatamatrixItem(OperationDataMatrixBarcode datamatrixItem) {
    if (this.datamatrix == null) {
      this.datamatrix = new ArrayList<>();
    }
    this.datamatrix.add(datamatrixItem);
    return this;
  }

  /**
   * Get datamatrix
   * @return datamatrix
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_DATAMATRIX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationDataMatrixBarcode> getDatamatrix() {
    return datamatrix;
  }


  @JsonProperty(JSON_PROPERTY_DATAMATRIX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDatamatrix(List<OperationDataMatrixBarcode> datamatrix) {
    this.datamatrix = datamatrix;
  }


  public OperationAddBarcode ean13(List<OperationEan13Barcode> ean13) {
    
    this.ean13 = ean13;
    return this;
  }

  public OperationAddBarcode addEan13Item(OperationEan13Barcode ean13Item) {
    if (this.ean13 == null) {
      this.ean13 = new ArrayList<>();
    }
    this.ean13.add(ean13Item);
    return this;
  }

  /**
   * Get ean13
   * @return ean13
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_EAN13)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationEan13Barcode> getEan13() {
    return ean13;
  }


  @JsonProperty(JSON_PROPERTY_EAN13)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEan13(List<OperationEan13Barcode> ean13) {
    this.ean13 = ean13;
  }


  public OperationAddBarcode ean8(List<OperationEan8Barcode> ean8) {
    
    this.ean8 = ean8;
    return this;
  }

  public OperationAddBarcode addEan8Item(OperationEan8Barcode ean8Item) {
    if (this.ean8 == null) {
      this.ean8 = new ArrayList<>();
    }
    this.ean8.add(ean8Item);
    return this;
  }

  /**
   * Get ean8
   * @return ean8
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_EAN8)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationEan8Barcode> getEan8() {
    return ean8;
  }


  @JsonProperty(JSON_PROPERTY_EAN8)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEan8(List<OperationEan8Barcode> ean8) {
    this.ean8 = ean8;
  }


  public OperationAddBarcode itf(List<OperationItfBarcode> itf) {
    
    this.itf = itf;
    return this;
  }

  public OperationAddBarcode addItfItem(OperationItfBarcode itfItem) {
    if (this.itf == null) {
      this.itf = new ArrayList<>();
    }
    this.itf.add(itfItem);
    return this;
  }

  /**
   * Get itf
   * @return itf
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ITF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationItfBarcode> getItf() {
    return itf;
  }


  @JsonProperty(JSON_PROPERTY_ITF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItf(List<OperationItfBarcode> itf) {
    this.itf = itf;
  }


  public OperationAddBarcode outputFormat(OutputFormatEnum outputFormat) {
    
    this.outputFormat = outputFormat;
    return this;
  }

  /**
   * Defines the output format for the barcode generation. The resulting document will be created by this webservice, where selected image formats will completly ignore a possibly given PDF source document and will only contain the barcode image.  **Important:** This parameter is for internal use only. Please only set this value to anything other than \&quot;pdf\&quot;, if you are really sure that you need to do so.
   * @return outputFormat
   **/
  @Nullable
  @Schema(name = "Defines the output format for the barcode generation. The resulting document will be created by this webservice, where selected image formats will completly ignore a possibly given PDF source document and will only contain the barcode image.  **Important:** This parameter is for internal use only. Please only set this value to anything other than \"pdf\", if you are really sure that you need to do so.")
  @JsonProperty(JSON_PROPERTY_OUTPUT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OutputFormatEnum getOutputFormat() {
    return outputFormat;
  }


  @JsonProperty(JSON_PROPERTY_OUTPUT_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutputFormat(OutputFormatEnum outputFormat) {
    this.outputFormat = outputFormat;
  }


  public OperationAddBarcode pdf417(List<OperationPdf417Barcode> pdf417) {
    
    this.pdf417 = pdf417;
    return this;
  }

  public OperationAddBarcode addPdf417Item(OperationPdf417Barcode pdf417Item) {
    if (this.pdf417 == null) {
      this.pdf417 = new ArrayList<>();
    }
    this.pdf417.add(pdf417Item);
    return this;
  }

  /**
   * Get pdf417
   * @return pdf417
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PDF417)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationPdf417Barcode> getPdf417() {
    return pdf417;
  }


  @JsonProperty(JSON_PROPERTY_PDF417)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPdf417(List<OperationPdf417Barcode> pdf417) {
    this.pdf417 = pdf417;
  }


  public OperationAddBarcode qrcode(List<OperationQrBarcode> qrcode) {
    
    this.qrcode = qrcode;
    return this;
  }

  public OperationAddBarcode addQrcodeItem(OperationQrBarcode qrcodeItem) {
    if (this.qrcode == null) {
      this.qrcode = new ArrayList<>();
    }
    this.qrcode.add(qrcodeItem);
    return this;
  }

  /**
   * Get qrcode
   * @return qrcode
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_QRCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationQrBarcode> getQrcode() {
    return qrcode;
  }


  @JsonProperty(JSON_PROPERTY_QRCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQrcode(List<OperationQrBarcode> qrcode) {
    this.qrcode = qrcode;
  }


  public OperationAddBarcode qrswiss(List<OperationQrSwissPaymentBarcode> qrswiss) {
    
    this.qrswiss = qrswiss;
    return this;
  }

  public OperationAddBarcode addQrswissItem(OperationQrSwissPaymentBarcode qrswissItem) {
    if (this.qrswiss == null) {
      this.qrswiss = new ArrayList<>();
    }
    this.qrswiss.add(qrswissItem);
    return this;
  }

  /**
   * Get qrswiss
   * @return qrswiss
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_QRSWISS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationQrSwissPaymentBarcode> getQrswiss() {
    return qrswiss;
  }


  @JsonProperty(JSON_PROPERTY_QRSWISS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQrswiss(List<OperationQrSwissPaymentBarcode> qrswiss) {
    this.qrswiss = qrswiss;
  }


  public OperationAddBarcode upca(List<OperationUpcaBarcode> upca) {
    
    this.upca = upca;
    return this;
  }

  public OperationAddBarcode addUpcaItem(OperationUpcaBarcode upcaItem) {
    if (this.upca == null) {
      this.upca = new ArrayList<>();
    }
    this.upca.add(upcaItem);
    return this;
  }

  /**
   * Get upca
   * @return upca
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_UPCA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationUpcaBarcode> getUpca() {
    return upca;
  }


  @JsonProperty(JSON_PROPERTY_UPCA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpca(List<OperationUpcaBarcode> upca) {
    this.upca = upca;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationAddBarcode operationAddBarcode = (OperationAddBarcode) o;
    return Objects.equals(this.aztec, operationAddBarcode.aztec) &&
        Objects.equals(this.codabar, operationAddBarcode.codabar) &&
        Objects.equals(this.code128, operationAddBarcode.code128) &&
        Objects.equals(this.code39, operationAddBarcode.code39) &&
        Objects.equals(this.datamatrix, operationAddBarcode.datamatrix) &&
        Objects.equals(this.ean13, operationAddBarcode.ean13) &&
        Objects.equals(this.ean8, operationAddBarcode.ean8) &&
        Objects.equals(this.itf, operationAddBarcode.itf) &&
        Objects.equals(this.outputFormat, operationAddBarcode.outputFormat) &&
        Objects.equals(this.pdf417, operationAddBarcode.pdf417) &&
        Objects.equals(this.qrcode, operationAddBarcode.qrcode) &&
        Objects.equals(this.qrswiss, operationAddBarcode.qrswiss) &&
        Objects.equals(this.upca, operationAddBarcode.upca);
  }

  @Override
  public int hashCode() {
    return Objects.hash(aztec, codabar, code128, code39, datamatrix, ean13, ean8, itf, outputFormat, pdf417, qrcode, qrswiss, upca);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationAddBarcode {\n");
    sb.append("    aztec: ").append(toIndentedString(aztec)).append("\n");
    sb.append("    codabar: ").append(toIndentedString(codabar)).append("\n");
    sb.append("    code128: ").append(toIndentedString(code128)).append("\n");
    sb.append("    code39: ").append(toIndentedString(code39)).append("\n");
    sb.append("    datamatrix: ").append(toIndentedString(datamatrix)).append("\n");
    sb.append("    ean13: ").append(toIndentedString(ean13)).append("\n");
    sb.append("    ean8: ").append(toIndentedString(ean8)).append("\n");
    sb.append("    itf: ").append(toIndentedString(itf)).append("\n");
    sb.append("    outputFormat: ").append(toIndentedString(outputFormat)).append("\n");
    sb.append("    pdf417: ").append(toIndentedString(pdf417)).append("\n");
    sb.append("    qrcode: ").append(toIndentedString(qrcode)).append("\n");
    sb.append("    qrswiss: ").append(toIndentedString(qrswiss)).append("\n");
    sb.append("    upca: ").append(toIndentedString(upca)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
