/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Lists a set of further settings and definitions, that a Reader may honor, when displaying the document.
 */
@Schema(description = "Lists a set of further settings and definitions, that a Reader may honor, when displaying the document.")
@JsonPropertyOrder({
  MetadataViewerPreferences.JSON_PROPERTY_CENTER_WINDOW,
  MetadataViewerPreferences.JSON_PROPERTY_DISPLAY_DOC_TITLE,
  MetadataViewerPreferences.JSON_PROPERTY_DUPLEX,
  MetadataViewerPreferences.JSON_PROPERTY_FIT_WINDOW,
  MetadataViewerPreferences.JSON_PROPERTY_HIDE_MENU_BAR,
  MetadataViewerPreferences.JSON_PROPERTY_HIDE_TOOLBAR,
  MetadataViewerPreferences.JSON_PROPERTY_HIDE_WINDOW_U_I,
  MetadataViewerPreferences.JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE,
  MetadataViewerPreferences.JSON_PROPERTY_NUM_COPIES,
  MetadataViewerPreferences.JSON_PROPERTY_PRINT_AREA,
  MetadataViewerPreferences.JSON_PROPERTY_PRINT_CLIP,
  MetadataViewerPreferences.JSON_PROPERTY_PRINT_PAGE_RANGE,
  MetadataViewerPreferences.JSON_PROPERTY_PRINT_SCALING,
  MetadataViewerPreferences.JSON_PROPERTY_PRINT_TRAY_SELECTION,
  MetadataViewerPreferences.JSON_PROPERTY_TEXT_DIRECTION,
  MetadataViewerPreferences.JSON_PROPERTY_VIEW_AREA,
  MetadataViewerPreferences.JSON_PROPERTY_VIEW_CLIP
})
@JsonTypeName("Metadata_ViewerPreferences")

public class MetadataViewerPreferences {
  public static final String JSON_PROPERTY_CENTER_WINDOW = "centerWindow";
  private Boolean centerWindow = false;

  public static final String JSON_PROPERTY_DISPLAY_DOC_TITLE = "displayDocTitle";
  private Boolean displayDocTitle = false;

  /**
   * The duplex settings initially suggested when opening the Reader&#39;s print dialog.  *   none &#x3D; The Reader shall use it&#39;s default suggestion. *   simplex &#x3D; The Reader shall suggest simplex printing. *   duplexFlipShortEdge &#x3D; The Reader shall suggest duplex printing, flipping pages over the shorter edge. *   duplexFlipLongEdge &#x3D; The Reader shall suggest duplex printing, flipping pages over the longer edge.
   */
  public enum DuplexEnum {
    NONE("none"),
    
    SIMPLEX("simplex"),
    
    DUPLEXFLIPSHORTEDGE("duplexFlipShortEdge"),
    
    DUPLEXFLIPLONGEDGE("duplexFlipLongEdge");

    private String value;

    DuplexEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DuplexEnum fromValue(String value) {
      for (DuplexEnum b : DuplexEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DUPLEX = "duplex";
  private DuplexEnum duplex = DuplexEnum.NONE;

  public static final String JSON_PROPERTY_FIT_WINDOW = "fitWindow";
  private Boolean fitWindow = false;

  public static final String JSON_PROPERTY_HIDE_MENU_BAR = "hideMenuBar";
  private Boolean hideMenuBar = false;

  public static final String JSON_PROPERTY_HIDE_TOOLBAR = "hideToolbar";
  private Boolean hideToolbar = false;

  public static final String JSON_PROPERTY_HIDE_WINDOW_U_I = "hideWindowUI";
  private Boolean hideWindowUI = false;

  /**
   * When displaying a document in windowed mode, the Reader shall show the selected panel.  *   none &#x3D; No panel shall be opened. *   outlines &#x3D; The document&#39;s outlines shall be displayed. *   thumbnails &#x3D; The document&#39;s page thumbnails shall be shown. *   optionalContents &#x3D; document&#39;s layers (OCGs - Optional Content Groups) shall be displayed.
   */
  public enum NonFullScreenPageModeEnum {
    NONE("none"),
    
    OUTLINES("outlines"),
    
    THUMBNAILS("thumbnails"),
    
    OPTIONALCONTENTS("optionalContents");

    private String value;

    NonFullScreenPageModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonFullScreenPageModeEnum fromValue(String value) {
      for (NonFullScreenPageModeEnum b : NonFullScreenPageModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE = "nonFullScreenPageMode";
  private NonFullScreenPageModeEnum nonFullScreenPageMode = NonFullScreenPageModeEnum.NONE;

  public static final String JSON_PROPERTY_NUM_COPIES = "numCopies";
  private Integer numCopies = 1;

  /**
   * Selects the visible box, when displaying the document.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   */
  public enum PrintAreaEnum {
    MEDIABOX("mediaBox"),
    
    CROPBOX("cropBox"),
    
    BLEEDBOX("bleedBox"),
    
    TRIMBOX("trimBox"),
    
    ARTBOX("artBox");

    private String value;

    PrintAreaEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrintAreaEnum fromValue(String value) {
      for (PrintAreaEnum b : PrintAreaEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRINT_AREA = "printArea";
  private PrintAreaEnum printArea = PrintAreaEnum.CROPBOX;

  /**
   * Selects the visible box, when displaying the document.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   */
  public enum PrintClipEnum {
    MEDIABOX("mediaBox"),
    
    CROPBOX("cropBox"),
    
    BLEEDBOX("bleedBox"),
    
    TRIMBOX("trimBox"),
    
    ARTBOX("artBox");

    private String value;

    PrintClipEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrintClipEnum fromValue(String value) {
      for (PrintClipEnum b : PrintClipEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRINT_CLIP = "printClip";
  private PrintClipEnum printClip = PrintClipEnum.CROPBOX;

  public static final String JSON_PROPERTY_PRINT_PAGE_RANGE = "printPageRange";
  private String printPageRange = "";

  /**
   * The print scaling initially suggested when opening the Reader&#39;s print dialog.  *   readerDefault &#x3D; The Reader shall use it&#39;s default suggestion. *   byPDFSize &#x3D; The Reader shall suggest to not scale the document during printing.
   */
  public enum PrintScalingEnum {
    READERDEFAULT("readerDefault"),
    
    NOPRINTSCALING("noPrintScaling");

    private String value;

    PrintScalingEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrintScalingEnum fromValue(String value) {
      for (PrintScalingEnum b : PrintScalingEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRINT_SCALING = "printScaling";
  private PrintScalingEnum printScaling = PrintScalingEnum.READERDEFAULT;

  /**
   * The print tray selection initially suggested when opening the Reader&#39;s print dialog.  *   readerDefault &#x3D; The Reader shall use it&#39;s default suggestion. *   byPDFSize &#x3D; The Reader shall select a print tray, that matches the PDF&#39;s page dimensions.
   */
  public enum PrintTraySelectionEnum {
    READERDEFAULT("readerDefault"),
    
    BYPDFSIZE("byPDFSize");

    private String value;

    PrintTraySelectionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PrintTraySelectionEnum fromValue(String value) {
      for (PrintTraySelectionEnum b : PrintTraySelectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRINT_TRAY_SELECTION = "printTraySelection";
  private PrintTraySelectionEnum printTraySelection = PrintTraySelectionEnum.READERDEFAULT;

  /**
   * Selects the predominant document&#39;s text writing/reading direction.  *   leftToRight or *   rightToLeft
   */
  public enum TextDirectionEnum {
    LEFTTORIGHT("leftToRight"),
    
    RIGHTTOLEFT("rightToLeft");

    private String value;

    TextDirectionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TextDirectionEnum fromValue(String value) {
      for (TextDirectionEnum b : TextDirectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TEXT_DIRECTION = "textDirection";
  private TextDirectionEnum textDirection = TextDirectionEnum.LEFTTORIGHT;

  /**
   * Selects the visible box, when displaying the document.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   */
  public enum ViewAreaEnum {
    MEDIABOX("mediaBox"),
    
    CROPBOX("cropBox"),
    
    BLEEDBOX("bleedBox"),
    
    TRIMBOX("trimBox"),
    
    ARTBOX("artBox");

    private String value;

    ViewAreaEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ViewAreaEnum fromValue(String value) {
      for (ViewAreaEnum b : ViewAreaEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VIEW_AREA = "viewArea";
  private ViewAreaEnum viewArea = ViewAreaEnum.CROPBOX;

  /**
   * Selects the visible box, when displaying the document.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   */
  public enum ViewClipEnum {
    MEDIABOX("mediaBox"),
    
    CROPBOX("cropBox"),
    
    BLEEDBOX("bleedBox"),
    
    TRIMBOX("trimBox"),
    
    ARTBOX("artBox");

    private String value;

    ViewClipEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ViewClipEnum fromValue(String value) {
      for (ViewClipEnum b : ViewClipEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VIEW_CLIP = "viewClip";
  private ViewClipEnum viewClip = ViewClipEnum.CROPBOX;

  public MetadataViewerPreferences() {
  }

  public MetadataViewerPreferences centerWindow(Boolean centerWindow) {
    
    this.centerWindow = centerWindow;
    return this;
  }

  /**
   * The Reader&#39;s window shall be positioned at the center of the screen, when opening the document.
   * @return centerWindow
   **/
  @Nullable
  @Schema(name = "The Reader's window shall be positioned at the center of the screen, when opening the document.")
  @JsonProperty(JSON_PROPERTY_CENTER_WINDOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCenterWindow() {
    return centerWindow;
  }


  @JsonProperty(JSON_PROPERTY_CENTER_WINDOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCenterWindow(Boolean centerWindow) {
    this.centerWindow = centerWindow;
  }


  public MetadataViewerPreferences displayDocTitle(Boolean displayDocTitle) {
    
    this.displayDocTitle = displayDocTitle;
    return this;
  }

  /**
   * Instead of the file name the reader shall display the title of the document in it&#39;s title bar.
   * @return displayDocTitle
   **/
  @Nullable
  @Schema(name = "Instead of the file name the reader shall display the title of the document in it's title bar.")
  @JsonProperty(JSON_PROPERTY_DISPLAY_DOC_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisplayDocTitle() {
    return displayDocTitle;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_DOC_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayDocTitle(Boolean displayDocTitle) {
    this.displayDocTitle = displayDocTitle;
  }


  public MetadataViewerPreferences duplex(DuplexEnum duplex) {
    
    this.duplex = duplex;
    return this;
  }

  /**
   * The duplex settings initially suggested when opening the Reader&#39;s print dialog.  *   none &#x3D; The Reader shall use it&#39;s default suggestion. *   simplex &#x3D; The Reader shall suggest simplex printing. *   duplexFlipShortEdge &#x3D; The Reader shall suggest duplex printing, flipping pages over the shorter edge. *   duplexFlipLongEdge &#x3D; The Reader shall suggest duplex printing, flipping pages over the longer edge.
   * @return duplex
   **/
  @Nullable
  @Schema(name = "The duplex settings initially suggested when opening the Reader's print dialog.  *   none = The Reader shall use it's default suggestion. *   simplex = The Reader shall suggest simplex printing. *   duplexFlipShortEdge = The Reader shall suggest duplex printing, flipping pages over the shorter edge. *   duplexFlipLongEdge = The Reader shall suggest duplex printing, flipping pages over the longer edge.")
  @JsonProperty(JSON_PROPERTY_DUPLEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DuplexEnum getDuplex() {
    return duplex;
  }


  @JsonProperty(JSON_PROPERTY_DUPLEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuplex(DuplexEnum duplex) {
    this.duplex = duplex;
  }


  public MetadataViewerPreferences fitWindow(Boolean fitWindow) {
    
    this.fitWindow = fitWindow;
    return this;
  }

  /**
   * The dimensions of the Reader&#39;s window shall adapt to the first displayed page of the document.
   * @return fitWindow
   **/
  @Nullable
  @Schema(name = "The dimensions of the Reader's window shall adapt to the first displayed page of the document.")
  @JsonProperty(JSON_PROPERTY_FIT_WINDOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFitWindow() {
    return fitWindow;
  }


  @JsonProperty(JSON_PROPERTY_FIT_WINDOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFitWindow(Boolean fitWindow) {
    this.fitWindow = fitWindow;
  }


  public MetadataViewerPreferences hideMenuBar(Boolean hideMenuBar) {
    
    this.hideMenuBar = hideMenuBar;
    return this;
  }

  /**
   * The Reader&#39;s menu bar shall be hidden, when opening the document.
   * @return hideMenuBar
   **/
  @Nullable
  @Schema(name = "The Reader's menu bar shall be hidden, when opening the document.")
  @JsonProperty(JSON_PROPERTY_HIDE_MENU_BAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHideMenuBar() {
    return hideMenuBar;
  }


  @JsonProperty(JSON_PROPERTY_HIDE_MENU_BAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideMenuBar(Boolean hideMenuBar) {
    this.hideMenuBar = hideMenuBar;
  }


  public MetadataViewerPreferences hideToolbar(Boolean hideToolbar) {
    
    this.hideToolbar = hideToolbar;
    return this;
  }

  /**
   * The Reader&#39;s toolbars shall be hidden, when opening the document.
   * @return hideToolbar
   **/
  @Nullable
  @Schema(name = "The Reader's toolbars shall be hidden, when opening the document.")
  @JsonProperty(JSON_PROPERTY_HIDE_TOOLBAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHideToolbar() {
    return hideToolbar;
  }


  @JsonProperty(JSON_PROPERTY_HIDE_TOOLBAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideToolbar(Boolean hideToolbar) {
    this.hideToolbar = hideToolbar;
  }


  public MetadataViewerPreferences hideWindowUI(Boolean hideWindowUI) {
    
    this.hideWindowUI = hideWindowUI;
    return this;
  }

  /**
   * The Reader&#39;s navigation controls (such as scrollbars) shall be hidden, when opening the document.
   * @return hideWindowUI
   **/
  @Nullable
  @Schema(name = "The Reader's navigation controls (such as scrollbars) shall be hidden, when opening the document.")
  @JsonProperty(JSON_PROPERTY_HIDE_WINDOW_U_I)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHideWindowUI() {
    return hideWindowUI;
  }


  @JsonProperty(JSON_PROPERTY_HIDE_WINDOW_U_I)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHideWindowUI(Boolean hideWindowUI) {
    this.hideWindowUI = hideWindowUI;
  }


  public MetadataViewerPreferences nonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
    
    this.nonFullScreenPageMode = nonFullScreenPageMode;
    return this;
  }

  /**
   * When displaying a document in windowed mode, the Reader shall show the selected panel.  *   none &#x3D; No panel shall be opened. *   outlines &#x3D; The document&#39;s outlines shall be displayed. *   thumbnails &#x3D; The document&#39;s page thumbnails shall be shown. *   optionalContents &#x3D; document&#39;s layers (OCGs - Optional Content Groups) shall be displayed.
   * @return nonFullScreenPageMode
   **/
  @Nullable
  @Schema(name = "When displaying a document in windowed mode, the Reader shall show the selected panel.  *   none = No panel shall be opened. *   outlines = The document's outlines shall be displayed. *   thumbnails = The document's page thumbnails shall be shown. *   optionalContents = document's layers (OCGs - Optional Content Groups) shall be displayed.")
  @JsonProperty(JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonFullScreenPageModeEnum getNonFullScreenPageMode() {
    return nonFullScreenPageMode;
  }


  @JsonProperty(JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
    this.nonFullScreenPageMode = nonFullScreenPageMode;
  }


  public MetadataViewerPreferences numCopies(Integer numCopies) {
    
    this.numCopies = numCopies;
    return this;
  }

  /**
   * The number of copies initially suggested, when opening the Reader&#39;s print dialog.
   * minimum: 1
   * @return numCopies
   **/
  @Nullable
  @Schema(name = "The number of copies initially suggested, when opening the Reader's print dialog.")
  @JsonProperty(JSON_PROPERTY_NUM_COPIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumCopies() {
    return numCopies;
  }


  @JsonProperty(JSON_PROPERTY_NUM_COPIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumCopies(Integer numCopies) {
    this.numCopies = numCopies;
  }


  public MetadataViewerPreferences printArea(PrintAreaEnum printArea) {
    
    this.printArea = printArea;
    return this;
  }

  /**
   * Selects the visible box, when displaying the document.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   * @return printArea
   **/
  @Nullable
  @Schema(name = "Selects the visible box, when displaying the document.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
  @JsonProperty(JSON_PROPERTY_PRINT_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrintAreaEnum getPrintArea() {
    return printArea;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintArea(PrintAreaEnum printArea) {
    this.printArea = printArea;
  }


  public MetadataViewerPreferences printClip(PrintClipEnum printClip) {
    
    this.printClip = printClip;
    return this;
  }

  /**
   * Selects the visible box, when displaying the document.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   * @return printClip
   **/
  @Nullable
  @Schema(name = "Selects the visible box, when displaying the document.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
  @JsonProperty(JSON_PROPERTY_PRINT_CLIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrintClipEnum getPrintClip() {
    return printClip;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_CLIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintClip(PrintClipEnum printClip) {
    this.printClip = printClip;
  }


  public MetadataViewerPreferences printPageRange(String printPageRange) {
    
    this.printPageRange = printPageRange;
    return this;
  }

  /**
   * Selects the page range, that shall initially be suggested for printing, when opening the Reader&#39;s print dialog. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \&quot;1,5-6,9\&quot;). To specify \&quot;all pages,\&quot; use an asterisk (\&quot;\\*\&quot;).
   * @return printPageRange
   **/
  @Nullable
  @Schema(name = "Selects the page range, that shall initially be suggested for printing, when opening the Reader's print dialog. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). To specify \"all pages,\" use an asterisk (\"\\*\").")
  @JsonProperty(JSON_PROPERTY_PRINT_PAGE_RANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrintPageRange() {
    return printPageRange;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_PAGE_RANGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintPageRange(String printPageRange) {
    this.printPageRange = printPageRange;
  }


  public MetadataViewerPreferences printScaling(PrintScalingEnum printScaling) {
    
    this.printScaling = printScaling;
    return this;
  }

  /**
   * The print scaling initially suggested when opening the Reader&#39;s print dialog.  *   readerDefault &#x3D; The Reader shall use it&#39;s default suggestion. *   byPDFSize &#x3D; The Reader shall suggest to not scale the document during printing.
   * @return printScaling
   **/
  @Nullable
  @Schema(name = "The print scaling initially suggested when opening the Reader's print dialog.  *   readerDefault = The Reader shall use it's default suggestion. *   byPDFSize = The Reader shall suggest to not scale the document during printing.")
  @JsonProperty(JSON_PROPERTY_PRINT_SCALING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrintScalingEnum getPrintScaling() {
    return printScaling;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_SCALING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintScaling(PrintScalingEnum printScaling) {
    this.printScaling = printScaling;
  }


  public MetadataViewerPreferences printTraySelection(PrintTraySelectionEnum printTraySelection) {
    
    this.printTraySelection = printTraySelection;
    return this;
  }

  /**
   * The print tray selection initially suggested when opening the Reader&#39;s print dialog.  *   readerDefault &#x3D; The Reader shall use it&#39;s default suggestion. *   byPDFSize &#x3D; The Reader shall select a print tray, that matches the PDF&#39;s page dimensions.
   * @return printTraySelection
   **/
  @Nullable
  @Schema(name = "The print tray selection initially suggested when opening the Reader's print dialog.  *   readerDefault = The Reader shall use it's default suggestion. *   byPDFSize = The Reader shall select a print tray, that matches the PDF's page dimensions.")
  @JsonProperty(JSON_PROPERTY_PRINT_TRAY_SELECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrintTraySelectionEnum getPrintTraySelection() {
    return printTraySelection;
  }


  @JsonProperty(JSON_PROPERTY_PRINT_TRAY_SELECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintTraySelection(PrintTraySelectionEnum printTraySelection) {
    this.printTraySelection = printTraySelection;
  }


  public MetadataViewerPreferences textDirection(TextDirectionEnum textDirection) {
    
    this.textDirection = textDirection;
    return this;
  }

  /**
   * Selects the predominant document&#39;s text writing/reading direction.  *   leftToRight or *   rightToLeft
   * @return textDirection
   **/
  @Nullable
  @Schema(name = "Selects the predominant document's text writing/reading direction.  *   leftToRight or *   rightToLeft")
  @JsonProperty(JSON_PROPERTY_TEXT_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TextDirectionEnum getTextDirection() {
    return textDirection;
  }


  @JsonProperty(JSON_PROPERTY_TEXT_DIRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTextDirection(TextDirectionEnum textDirection) {
    this.textDirection = textDirection;
  }


  public MetadataViewerPreferences viewArea(ViewAreaEnum viewArea) {
    
    this.viewArea = viewArea;
    return this;
  }

  /**
   * Selects the visible box, when displaying the document.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   * @return viewArea
   **/
  @Nullable
  @Schema(name = "Selects the visible box, when displaying the document.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
  @JsonProperty(JSON_PROPERTY_VIEW_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ViewAreaEnum getViewArea() {
    return viewArea;
  }


  @JsonProperty(JSON_PROPERTY_VIEW_AREA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewArea(ViewAreaEnum viewArea) {
    this.viewArea = viewArea;
  }


  public MetadataViewerPreferences viewClip(ViewClipEnum viewClip) {
    
    this.viewClip = viewClip;
    return this;
  }

  /**
   * Selects the visible box, when displaying the document.  *   media\\_box &#x3D; The page&#39;s physical dimensions. *   crop\\_box &#x3D; The visible (printable) page area. *   bleed\\_box &#x3D; Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box &#x3D; Trimmed content position on the page (final content dimensions). *   art\\_box &#x3D; Position for special page content (images).
   * @return viewClip
   **/
  @Nullable
  @Schema(name = "Selects the visible box, when displaying the document.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
  @JsonProperty(JSON_PROPERTY_VIEW_CLIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ViewClipEnum getViewClip() {
    return viewClip;
  }


  @JsonProperty(JSON_PROPERTY_VIEW_CLIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewClip(ViewClipEnum viewClip) {
    this.viewClip = viewClip;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataViewerPreferences metadataViewerPreferences = (MetadataViewerPreferences) o;
    return Objects.equals(this.centerWindow, metadataViewerPreferences.centerWindow) &&
        Objects.equals(this.displayDocTitle, metadataViewerPreferences.displayDocTitle) &&
        Objects.equals(this.duplex, metadataViewerPreferences.duplex) &&
        Objects.equals(this.fitWindow, metadataViewerPreferences.fitWindow) &&
        Objects.equals(this.hideMenuBar, metadataViewerPreferences.hideMenuBar) &&
        Objects.equals(this.hideToolbar, metadataViewerPreferences.hideToolbar) &&
        Objects.equals(this.hideWindowUI, metadataViewerPreferences.hideWindowUI) &&
        Objects.equals(this.nonFullScreenPageMode, metadataViewerPreferences.nonFullScreenPageMode) &&
        Objects.equals(this.numCopies, metadataViewerPreferences.numCopies) &&
        Objects.equals(this.printArea, metadataViewerPreferences.printArea) &&
        Objects.equals(this.printClip, metadataViewerPreferences.printClip) &&
        Objects.equals(this.printPageRange, metadataViewerPreferences.printPageRange) &&
        Objects.equals(this.printScaling, metadataViewerPreferences.printScaling) &&
        Objects.equals(this.printTraySelection, metadataViewerPreferences.printTraySelection) &&
        Objects.equals(this.textDirection, metadataViewerPreferences.textDirection) &&
        Objects.equals(this.viewArea, metadataViewerPreferences.viewArea) &&
        Objects.equals(this.viewClip, metadataViewerPreferences.viewClip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(centerWindow, displayDocTitle, duplex, fitWindow, hideMenuBar, hideToolbar, hideWindowUI, nonFullScreenPageMode, numCopies, printArea, printClip, printPageRange, printScaling, printTraySelection, textDirection, viewArea, viewClip);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataViewerPreferences {\n");
    sb.append("    centerWindow: ").append(toIndentedString(centerWindow)).append("\n");
    sb.append("    displayDocTitle: ").append(toIndentedString(displayDocTitle)).append("\n");
    sb.append("    duplex: ").append(toIndentedString(duplex)).append("\n");
    sb.append("    fitWindow: ").append(toIndentedString(fitWindow)).append("\n");
    sb.append("    hideMenuBar: ").append(toIndentedString(hideMenuBar)).append("\n");
    sb.append("    hideToolbar: ").append(toIndentedString(hideToolbar)).append("\n");
    sb.append("    hideWindowUI: ").append(toIndentedString(hideWindowUI)).append("\n");
    sb.append("    nonFullScreenPageMode: ").append(toIndentedString(nonFullScreenPageMode)).append("\n");
    sb.append("    numCopies: ").append(toIndentedString(numCopies)).append("\n");
    sb.append("    printArea: ").append(toIndentedString(printArea)).append("\n");
    sb.append("    printClip: ").append(toIndentedString(printClip)).append("\n");
    sb.append("    printPageRange: ").append(toIndentedString(printPageRange)).append("\n");
    sb.append("    printScaling: ").append(toIndentedString(printScaling)).append("\n");
    sb.append("    printTraySelection: ").append(toIndentedString(printTraySelection)).append("\n");
    sb.append("    textDirection: ").append(toIndentedString(textDirection)).append("\n");
    sb.append("    viewArea: ").append(toIndentedString(viewArea)).append("\n");
    sb.append("    viewClip: ").append(toIndentedString(viewClip)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
