/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Properties listed in the Adobe piece info.
 */
@Schema(description = "Properties listed in the Adobe piece info.")
@JsonPropertyOrder({
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_ABSOLUTE_SCALING,
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_ALIGNMENT,
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_COLOR,
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_HORIZ_OFFSET,
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_OPACITY,
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_ROTATION,
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_SCALE,
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_UNIT,
  MetadataPieceInfoBackgroundContent.JSON_PROPERTY_VERT_OFFSET
})
@JsonTypeName("Metadata_PieceInfoBackgroundContent")

public class MetadataPieceInfoBackgroundContent {
  public static final String JSON_PROPERTY_ABSOLUTE_SCALING = "absoluteScaling";
  private Boolean absoluteScaling = true;

  /**
   * Uses one of multiple preset positions in order to position the background on the page.  *   custom &#x3D; Disable the use of a preset position. *   top\\_left &#x3D; Positions the background in the top left corner. *   top\\_center &#x3D; Positions the background in the centre on the top margin. *   top\\_right &#x3D; Positions the background in the top right corner. *   center\\_left &#x3D; Positions the background at the centre of the page, to the left. *   center\\_center &#x3D; Positions the background at the centre of the page. *   center\\_right &#x3D; Positions the background at the centre of the page, to the right. *   bottom\\_left &#x3D; Positions the background in the bottom left corner. *   bottom\\_center &#x3D; Positions the background in the centre on the bottom margin. *   bottom\\_right &#x3D; Positions the background in the bottom right corner.
   */
  public enum AlignmentEnum {
    TOP_LEFT("top_left"),
    
    TOP_CENTER("top_center"),
    
    TOP_RIGHT("top_right"),
    
    CENTER_LEFT("center_left"),
    
    CENTER_CENTER("center_center"),
    
    CENTER_RIGHT("center_right"),
    
    BOTTOM_LEFT("bottom_left"),
    
    BOTTOM_CENTER("bottom_center"),
    
    BOTTOM_RIGHT("bottom_right");

    private String value;

    AlignmentEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AlignmentEnum fromValue(String value) {
      for (AlignmentEnum b : AlignmentEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ALIGNMENT = "alignment";
  private AlignmentEnum alignment = AlignmentEnum.TOP_LEFT;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color = "#FFFFFF";

  public static final String JSON_PROPERTY_HORIZ_OFFSET = "horizOffset";
  private Float horizOffset = 0.0f;

  public static final String JSON_PROPERTY_OPACITY = "opacity";
  private Float opacity = 1.0f;

  public static final String JSON_PROPERTY_ROTATION = "rotation";
  private Integer rotation = 0;

  public static final String JSON_PROPERTY_SCALE = "scale";
  private Float scale = 1f;

  public static final String JSON_PROPERTY_UNIT = "unit";
  private String unit = "";

  public static final String JSON_PROPERTY_VERT_OFFSET = "vertOffset";
  private Float vertOffset = 0.0f;

  public MetadataPieceInfoBackgroundContent() {
  }

  public MetadataPieceInfoBackgroundContent absoluteScaling(Boolean absoluteScaling) {
    
    this.absoluteScaling = absoluteScaling;
    return this;
  }

  /**
   * When set to true the page shall be scaled relative to it&#39;s own original dimensions, when set to false, it shall be scaled relative to the page dimensions.
   * @return absoluteScaling
   **/
  @Nullable
  @Schema(name = "When set to true the page shall be scaled relative to it's own original dimensions, when set to false, it shall be scaled relative to the page dimensions.")
  @JsonProperty(JSON_PROPERTY_ABSOLUTE_SCALING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAbsoluteScaling() {
    return absoluteScaling;
  }


  @JsonProperty(JSON_PROPERTY_ABSOLUTE_SCALING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAbsoluteScaling(Boolean absoluteScaling) {
    this.absoluteScaling = absoluteScaling;
  }


  public MetadataPieceInfoBackgroundContent alignment(AlignmentEnum alignment) {
    
    this.alignment = alignment;
    return this;
  }

  /**
   * Uses one of multiple preset positions in order to position the background on the page.  *   custom &#x3D; Disable the use of a preset position. *   top\\_left &#x3D; Positions the background in the top left corner. *   top\\_center &#x3D; Positions the background in the centre on the top margin. *   top\\_right &#x3D; Positions the background in the top right corner. *   center\\_left &#x3D; Positions the background at the centre of the page, to the left. *   center\\_center &#x3D; Positions the background at the centre of the page. *   center\\_right &#x3D; Positions the background at the centre of the page, to the right. *   bottom\\_left &#x3D; Positions the background in the bottom left corner. *   bottom\\_center &#x3D; Positions the background in the centre on the bottom margin. *   bottom\\_right &#x3D; Positions the background in the bottom right corner.
   * @return alignment
   **/
  @Nullable
  @Schema(name = "Uses one of multiple preset positions in order to position the background on the page.  *   custom = Disable the use of a preset position. *   top\\_left = Positions the background in the top left corner. *   top\\_center = Positions the background in the centre on the top margin. *   top\\_right = Positions the background in the top right corner. *   center\\_left = Positions the background at the centre of the page, to the left. *   center\\_center = Positions the background at the centre of the page. *   center\\_right = Positions the background at the centre of the page, to the right. *   bottom\\_left = Positions the background in the bottom left corner. *   bottom\\_center = Positions the background in the centre on the bottom margin. *   bottom\\_right = Positions the background in the bottom right corner.")
  @JsonProperty(JSON_PROPERTY_ALIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AlignmentEnum getAlignment() {
    return alignment;
  }


  @JsonProperty(JSON_PROPERTY_ALIGNMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlignment(AlignmentEnum alignment) {
    this.alignment = alignment;
  }


  public MetadataPieceInfoBackgroundContent color(String color) {
    
    this.color = color;
    return this;
  }

  /**
   * The color of a unicolor background.
   * @return color
   **/
  @Nullable
  @Schema(name = "The color of a unicolor background.")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public MetadataPieceInfoBackgroundContent horizOffset(Float horizOffset) {
    
    this.horizOffset = horizOffset;
    return this;
  }

  /**
   * The horizontal offset in relation to the backgrounds bas position.
   * @return horizOffset
   **/
  @Nullable
  @Schema(name = "The horizontal offset in relation to the backgrounds bas position.")
  @JsonProperty(JSON_PROPERTY_HORIZ_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getHorizOffset() {
    return horizOffset;
  }


  @JsonProperty(JSON_PROPERTY_HORIZ_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHorizOffset(Float horizOffset) {
    this.horizOffset = horizOffset;
  }


  public MetadataPieceInfoBackgroundContent opacity(Float opacity) {
    
    this.opacity = opacity;
    return this;
  }

  /**
   * The opacity of the background, as a percentage in the range 0.0 (fully transparent) to 1.0 (fully opaque).
   * minimum: 0
   * maximum: 1
   * @return opacity
   **/
  @Nullable
  @Schema(name = "The opacity of the background, as a percentage in the range 0.0 (fully transparent) to 1.0 (fully opaque).")
  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getOpacity() {
    return opacity;
  }


  @JsonProperty(JSON_PROPERTY_OPACITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpacity(Float opacity) {
    this.opacity = opacity;
  }


  public MetadataPieceInfoBackgroundContent rotation(Integer rotation) {
    
    this.rotation = rotation;
    return this;
  }

  /**
   * The rotation of the background.
   * minimum: 0
   * maximum: 360
   * @return rotation
   **/
  @Nullable
  @Schema(name = "The rotation of the background.")
  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRotation() {
    return rotation;
  }


  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotation(Integer rotation) {
    this.rotation = rotation;
  }


  public MetadataPieceInfoBackgroundContent scale(Float scale) {
    
    this.scale = scale;
    return this;
  }

  /**
   * The scaling of the background.
   * minimum: 0
   * @return scale
   **/
  @Nullable
  @Schema(name = "The scaling of the background.")
  @JsonProperty(JSON_PROPERTY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getScale() {
    return scale;
  }


  @JsonProperty(JSON_PROPERTY_SCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScale(Float scale) {
    this.scale = scale;
  }


  public MetadataPieceInfoBackgroundContent unit(String unit) {
    
    this.unit = unit;
    return this;
  }

  /**
   * The Adobe unit used to display offsets in readers. (millimeters, pica, point etc).
   * @return unit
   **/
  @Nullable
  @Schema(name = "The Adobe unit used to display offsets in readers. (millimeters, pica, point etc).")
  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUnit() {
    return unit;
  }


  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnit(String unit) {
    this.unit = unit;
  }


  public MetadataPieceInfoBackgroundContent vertOffset(Float vertOffset) {
    
    this.vertOffset = vertOffset;
    return this;
  }

  /**
   * The vertical offset in relation to the backgrounds bas position.
   * @return vertOffset
   **/
  @Nullable
  @Schema(name = "The vertical offset in relation to the backgrounds bas position.")
  @JsonProperty(JSON_PROPERTY_VERT_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getVertOffset() {
    return vertOffset;
  }


  @JsonProperty(JSON_PROPERTY_VERT_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVertOffset(Float vertOffset) {
    this.vertOffset = vertOffset;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataPieceInfoBackgroundContent metadataPieceInfoBackgroundContent = (MetadataPieceInfoBackgroundContent) o;
    return Objects.equals(this.absoluteScaling, metadataPieceInfoBackgroundContent.absoluteScaling) &&
        Objects.equals(this.alignment, metadataPieceInfoBackgroundContent.alignment) &&
        Objects.equals(this.color, metadataPieceInfoBackgroundContent.color) &&
        Objects.equals(this.horizOffset, metadataPieceInfoBackgroundContent.horizOffset) &&
        Objects.equals(this.opacity, metadataPieceInfoBackgroundContent.opacity) &&
        Objects.equals(this.rotation, metadataPieceInfoBackgroundContent.rotation) &&
        Objects.equals(this.scale, metadataPieceInfoBackgroundContent.scale) &&
        Objects.equals(this.unit, metadataPieceInfoBackgroundContent.unit) &&
        Objects.equals(this.vertOffset, metadataPieceInfoBackgroundContent.vertOffset);
  }

  @Override
  public int hashCode() {
    return Objects.hash(absoluteScaling, alignment, color, horizOffset, opacity, rotation, scale, unit, vertOffset);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataPieceInfoBackgroundContent {\n");
    sb.append("    absoluteScaling: ").append(toIndentedString(absoluteScaling)).append("\n");
    sb.append("    alignment: ").append(toIndentedString(alignment)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    horizOffset: ").append(toIndentedString(horizOffset)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    rotation: ").append(toIndentedString(rotation)).append("\n");
    sb.append("    scale: ").append(toIndentedString(scale)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    vertOffset: ").append(toIndentedString(vertOffset)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
