/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: TEST
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines a set of options specific for the \&quot;Converter\&quot; web service.
 */
@Schema(description = "Defines a set of options specific for the \"Converter\" web service.")
@JsonPropertyOrder({
  ApplicationConfigConverterWebservice.JSON_PROPERTY_DEFAULT_FONT,
  ApplicationConfigConverterWebservice.JSON_PROPERTY_ENABLED,
  ApplicationConfigConverterWebservice.JSON_PROPERTY_FONT_PATH,
  ApplicationConfigConverterWebservice.JSON_PROPERTY_INSTANCES,
  ApplicationConfigConverterWebservice.JSON_PROPERTY_MAX_LATENCY,
  ApplicationConfigConverterWebservice.JSON_PROPERTY_QUEUE_SIZE
})
@JsonTypeName("ApplicationConfig_ConverterWebservice")

public class ApplicationConfigConverterWebservice {
  public static final String JSON_PROPERTY_DEFAULT_FONT = "defaultFont";
  private String defaultFont = "";

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_FONT_PATH = "fontPath";
  private String fontPath = "";

  public static final String JSON_PROPERTY_INSTANCES = "instances";
  private Integer instances = 2;

  public static final String JSON_PROPERTY_MAX_LATENCY = "maxLatency";
  private Integer maxLatency = 180;

  public static final String JSON_PROPERTY_QUEUE_SIZE = "queueSize";
  private Integer queueSize = 100;

  public ApplicationConfigConverterWebservice() {
  }

  public ApplicationConfigConverterWebservice defaultFont(String defaultFont) {
    
    this.defaultFont = defaultFont;
    return this;
  }

  /**
   * Sets the default font to be used if the original font was not found and no matching character (for representation) was found in any other font with a similar font family or characteristic. Therefore, a font should be used that has the widest possible coverage of characters, especially in the Unicode range.  **Note:** If no font is specified, then the server tries to find a suitable font (such as \&quot;Arial Unicode MS\&quot; or \&quot;Go Noto Current\&quot;). If these fonts are not available, then the respective default font of the operating system (under Windows \&quot;Arial\&quot; and under Linux \&quot;DejaVu Sans\&quot;) is used. If these are not available either, then a corresponding message appears on the server console (or in the logs).  **Important:** This setting is supported only by the built-in document converter OutsideIn.
   * @return defaultFont
   **/
  @Nullable
  @Schema(name = "Sets the default font to be used if the original font was not found and no matching character (for representation) was found in any other font with a similar font family or characteristic. Therefore, a font should be used that has the widest possible coverage of characters, especially in the Unicode range.  **Note:** If no font is specified, then the server tries to find a suitable font (such as \"Arial Unicode MS\" or \"Go Noto Current\"). If these fonts are not available, then the respective default font of the operating system (under Windows \"Arial\" and under Linux \"DejaVu Sans\") is used. If these are not available either, then a corresponding message appears on the server console (or in the logs).  **Important:** This setting is supported only by the built-in document converter OutsideIn.")
  @JsonProperty(JSON_PROPERTY_DEFAULT_FONT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultFont() {
    return defaultFont;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_FONT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultFont(String defaultFont) {
    this.defaultFont = defaultFont;
  }


  public ApplicationConfigConverterWebservice enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

  /**
   * If enabled, then the web service is activated.
   * @return enabled
   **/
  @Nullable
  @Schema(name = "If enabled, then the web service is activated.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public ApplicationConfigConverterWebservice fontPath(String fontPath) {
    
    this.fontPath = fontPath;
    return this;
  }

  /**
   * Sets the base path (including subfolders) of the server from which to retrieve installed fonts.  If no value is specified, then the default font directories (including subfolders) of the respective operating system are used. Under Windows this is usually &#x60;C:\\Windows\\Fonts&#x60; and under Linux &#x60;/usr/share/fonts/truetype&#x60;.  **Note:** On Linux, the home directory of the user under which the server is running is also always used in addition. The environment variable &#x60;user.home&#x60; with the subdirectory &#x60;.fonts&#x60; is used.  **Important:** This setting is supported only by the built-in document converter OutsideIn.
   * @return fontPath
   **/
  @Nullable
  @Schema(name = "Sets the base path (including subfolders) of the server from which to retrieve installed fonts.  If no value is specified, then the default font directories (including subfolders) of the respective operating system are used. Under Windows this is usually `C:\\Windows\\Fonts` and under Linux `/usr/share/fonts/truetype`.  **Note:** On Linux, the home directory of the user under which the server is running is also always used in addition. The environment variable `user.home` with the subdirectory `.fonts` is used.  **Important:** This setting is supported only by the built-in document converter OutsideIn.")
  @JsonProperty(JSON_PROPERTY_FONT_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFontPath() {
    return fontPath;
  }


  @JsonProperty(JSON_PROPERTY_FONT_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFontPath(String fontPath) {
    this.fontPath = fontPath;
  }


  public ApplicationConfigConverterWebservice instances(Integer instances) {
    
    this.instances = instances;
    return this;
  }

  /**
   * Number of parallel instances (threads) for the web service. Defines the number of requests that can be executed in parallel before requests are queued.
   * minimum: 1
   * @return instances
   **/
  @Nullable
  @Schema(name = "Number of parallel instances (threads) for the web service. Defines the number of requests that can be executed in parallel before requests are queued.")
  @JsonProperty(JSON_PROPERTY_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getInstances() {
    return instances;
  }


  @JsonProperty(JSON_PROPERTY_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstances(Integer instances) {
    this.instances = instances;
  }


  public ApplicationConfigConverterWebservice maxLatency(Integer maxLatency) {
    
    this.maxLatency = maxLatency;
    return this;
  }

  /**
   * Maximum time in seconds allowed for the execution of a web service before the request is aborted. When time is expired the execution is aborted.
   * minimum: 0
   * @return maxLatency
   **/
  @Nullable
  @Schema(name = "Maximum time in seconds allowed for the execution of a web service before the request is aborted. When time is expired the execution is aborted.")
  @JsonProperty(JSON_PROPERTY_MAX_LATENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLatency() {
    return maxLatency;
  }


  @JsonProperty(JSON_PROPERTY_MAX_LATENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLatency(Integer maxLatency) {
    this.maxLatency = maxLatency;
  }


  public ApplicationConfigConverterWebservice queueSize(Integer queueSize) {
    
    this.queueSize = queueSize;
    return this;
  }

  /**
   * Maximum number of waiting requests, before new requests are rejected. If there are more requests than free instances, they are placed in the queue. If this maximum value is reached, further requests are rejected directly.
   * @return queueSize
   **/
  @Nullable
  @Schema(name = "Maximum number of waiting requests, before new requests are rejected. If there are more requests than free instances, they are placed in the queue. If this maximum value is reached, further requests are rejected directly.")
  @JsonProperty(JSON_PROPERTY_QUEUE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQueueSize() {
    return queueSize;
  }


  @JsonProperty(JSON_PROPERTY_QUEUE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQueueSize(Integer queueSize) {
    this.queueSize = queueSize;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationConfigConverterWebservice applicationConfigConverterWebservice = (ApplicationConfigConverterWebservice) o;
    return Objects.equals(this.defaultFont, applicationConfigConverterWebservice.defaultFont) &&
        Objects.equals(this.enabled, applicationConfigConverterWebservice.enabled) &&
        Objects.equals(this.fontPath, applicationConfigConverterWebservice.fontPath) &&
        Objects.equals(this.instances, applicationConfigConverterWebservice.instances) &&
        Objects.equals(this.maxLatency, applicationConfigConverterWebservice.maxLatency) &&
        Objects.equals(this.queueSize, applicationConfigConverterWebservice.queueSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defaultFont, enabled, fontPath, instances, maxLatency, queueSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationConfigConverterWebservice {\n");
    sb.append("    defaultFont: ").append(toIndentedString(defaultFont)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    fontPath: ").append(toIndentedString(fontPath)).append("\n");
    sb.append("    instances: ").append(toIndentedString(instances)).append("\n");
    sb.append("    maxLatency: ").append(toIndentedString(maxLatency)).append("\n");
    sb.append("    queueSize: ").append(toIndentedString(queueSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
