
package net.webpdf.wsclient.schema.barcode;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for BarcodeEncodingsType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="BarcodeEncodingsType"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="aztec"/&gt;
 *     &lt;enumeration value="codabar"/&gt;
 *     &lt;enumeration value="code128"/&gt;
 *     &lt;enumeration value="code39"/&gt;
 *     &lt;enumeration value="code93"/&gt;
 *     &lt;enumeration value="datamatrix"/&gt;
 *     &lt;enumeration value="ean13"/&gt;
 *     &lt;enumeration value="ean8"/&gt;
 *     &lt;enumeration value="itf"/&gt;
 *     &lt;enumeration value="maxicode"/&gt;
 *     &lt;enumeration value="pdf417"/&gt;
 *     &lt;enumeration value="qrcode"/&gt;
 *     &lt;enumeration value="rssexpanded"/&gt;
 *     &lt;enumeration value="upca"/&gt;
 *     &lt;enumeration value="upce"/&gt;
 *     &lt;enumeration value="upceanextension"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "BarcodeEncodingsType")
@XmlEnum
public enum BarcodeEncodingsType {

    @XmlEnumValue("aztec")
    AZTEC("aztec"),
    @XmlEnumValue("codabar")
    CODABAR("codabar"),
    @XmlEnumValue("code128")
    CODE_128("code128"),
    @XmlEnumValue("code39")
    CODE_39("code39"),
    @XmlEnumValue("code93")
    CODE_93("code93"),
    @XmlEnumValue("datamatrix")
    DATAMATRIX("datamatrix"),
    @XmlEnumValue("ean13")
    EAN_13("ean13"),
    @XmlEnumValue("ean8")
    EAN_8("ean8"),
    @XmlEnumValue("itf")
    ITF("itf"),
    @XmlEnumValue("maxicode")
    MAXICODE("maxicode"),
    @XmlEnumValue("pdf417")
    PDF_417("pdf417"),
    @XmlEnumValue("qrcode")
    QRCODE("qrcode"),
    @XmlEnumValue("rssexpanded")
    RSSEXPANDED("rssexpanded"),
    @XmlEnumValue("upca")
    UPCA("upca"),
    @XmlEnumValue("upce")
    UPCE("upce"),
    @XmlEnumValue("upceanextension")
    UPCEANEXTENSION("upceanextension");
    private final String value;

    BarcodeEncodingsType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static BarcodeEncodingsType fromValue(String v) {
        for (BarcodeEncodingsType c: BarcodeEncodingsType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
