/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session;

import java.net.URI;
import java.net.URL;
import net.webpdf.wsclient.WSClientProxySelector;
import net.webpdf.wsclient.WebServiceProtocol;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.https.TLSContext;
import net.webpdf.wsclient.proxy.ProxyConfiguration;
import net.webpdf.wsclient.session.AbstractSession;
import net.webpdf.wsclient.session.DataFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoapSession
extends AbstractSession {
    private boolean useLocalWsdl = true;
    private WSClientProxySelector proxySelector = null;

    SoapSession(@NotNull URL url, @Nullable TLSContext tlsContext) throws ResultException {
        super(url, WebServiceProtocol.SOAP, tlsContext);
        this.dataFormat = DataFormat.XML;
    }

    @Override
    public void setProxy(@Nullable ProxyConfiguration proxy) throws ResultException {
        if (this.proxySelector != null) {
            this.proxySelector.close();
            this.proxySelector = null;
        }
        super.setProxy(proxy);
        if (proxy != null) {
            this.proxySelector = new WSClientProxySelector(new URI[]{this.getURI("")}, proxy.getHost());
        }
    }

    @Override
    public void close() {
        if (this.proxySelector != null) {
            this.proxySelector.close();
        }
    }

    public boolean isUseLocalWsdl() {
        return this.useLocalWsdl;
    }

    void setUseLocalWsdl(boolean useLocalWsdl) {
        this.useLocalWsdl = useLocalWsdl;
    }
}

