/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.https;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.http.AlwaysTrustManager;
import net.webpdf.wsclient.https.TLSProtocol;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TLSContext {
    private static final TrustManager[] TRUST_ALL = new TrustManager[]{new AlwaysTrustManager()};
    @Nullable
    private SSLContext sslContext;
    private boolean allowSelfSigned = false;
    @Nullable
    private File trustStore = null;
    @Nullable
    private String trustStorePassword = null;
    @NotNull
    private TLSProtocol tlsProtocol = TLSProtocol.TLSV1_2;

    private TLSContext() {
    }

    @NotNull
    public static TLSContext createDefault() {
        return new TLSContext();
    }

    private void initSSLContext() throws ResultException {
        try {
            if (this.trustStore != null || this.allowSelfSigned) {
                SSLContext sSLContext = this.trustStore != null ? new SSLContextBuilder().setProtocol(this.tlsProtocol.getName()).loadTrustMaterial(this.trustStore, this.trustStorePassword != null ? this.trustStorePassword.toCharArray() : null, null).build() : (this.sslContext = new SSLContextBuilder().setProtocol(this.tlsProtocol.getName()).build());
                if (this.allowSelfSigned) {
                    this.sslContext.init(new KeyManager[0], TRUST_ALL, new SecureRandom());
                }
            } else {
                this.sslContext = SSLContexts.createDefault();
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new ResultException(Result.build(Error.HTTPS_IO_ERROR, ex));
        }
    }

    public void setAllowSelfSigned(boolean allowSelfSigned) {
        this.allowSelfSigned = allowSelfSigned;
    }

    public void setTrustStore(@Nullable File trustStore, @Nullable String trustStorePassword) {
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
    }

    @NotNull
    public SSLContext getSslContext() throws ResultException {
        if (this.sslContext == null) {
            this.initSSLContext();
        }
        return this.sslContext;
    }

    public void setTLSProtocol(@NotNull TLSProtocol tlsProtocol) {
        this.tlsProtocol = tlsProtocol;
    }
}

