/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.documents;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import net.webpdf.wsclient.documents.AbstractDocument;
import net.webpdf.wsclient.documents.InputStreamDataSource;
import org.jetbrains.annotations.Nullable;

public class SoapDocument
extends AbstractDocument
implements AutoCloseable {
    @Nullable
    private InputStream inputStream;
    private boolean closeInput = false;
    @Nullable
    private OutputStream outputStream;
    private boolean closeOutput = false;

    public SoapDocument(@Nullable InputStream inputStream, @Nullable OutputStream outputStream) {
        super(null);
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public SoapDocument(@Nullable URI source, @Nullable File targetFile) {
        super(source);
        try {
            if (source != null && this.isFileSource()) {
                this.inputStream = new FileInputStream(new File(source));
                this.closeInput = true;
            }
            this.outputStream = targetFile != null ? new FileOutputStream(targetFile) : null;
            this.closeOutput = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public DataHandler getSourceDataHandler() {
        return this.inputStream != null ? new DataHandler((DataSource)new InputStreamDataSource(this.inputStream)) : null;
    }

    public void save(@Nullable DataHandler resultDataHandler) throws IOException {
        if (this.outputStream == null) {
            throw new IOException("No output stream available");
        }
        if (resultDataHandler == null) {
            throw new IOException("No document content available");
        }
        resultDataHandler.writeTo(this.outputStream);
        if (resultDataHandler instanceof Closeable) {
            ((Closeable)resultDataHandler).close();
        }
    }

    @Override
    public void close() {
        try {
            if (this.closeInput && this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.closeOutput && this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

