/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.documents;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.webpdf.wsclient.documents.AbstractDocument;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.schema.beans.DocumentFileBean;
import net.webpdf.wsclient.schema.beans.HistoryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestDocument
extends AbstractDocument {
    @NotNull
    private final ConcurrentHashMap<Integer, HistoryEntry> historyMap = new ConcurrentHashMap();
    @Nullable
    private final String documentId;
    @Nullable
    private DocumentFileBean documentFile;

    public RestDocument(@Nullable String documentId) {
        super(null);
        this.documentId = documentId;
    }

    @Nullable
    public String getSourceDocumentId() {
        if (this.documentId != null) {
            return this.documentId;
        }
        return this.documentFile != null ? this.documentFile.getDocumentId() : null;
    }

    @Nullable
    public DocumentFileBean getDocumentFile() {
        return this.documentFile;
    }

    public void setDocumentFile(@Nullable DocumentFileBean documentFile) {
        this.documentFile = documentFile;
    }

    void replaceHistoryEntry(@Nullable HistoryEntry historyEntry) throws ResultException {
        if (historyEntry == null) {
            throw new ResultException(Result.build(Error.INVALID_HISTORY_DATA));
        }
        int historyId = historyEntry.getId();
        if (!this.historyMap.containsKey(historyId)) {
            throw new ResultException(Result.build(Error.INVALID_HISTORY_DATA));
        }
        if (historyEntry.isActive()) {
            for (Map.Entry<Integer, HistoryEntry> entry : this.historyMap.entrySet()) {
                entry.getValue().setActive(false);
            }
        }
        this.historyMap.put(historyId, historyEntry);
    }

    void storeHistory(HistoryEntry[] historyEntries) {
        this.historyMap.clear();
        for (HistoryEntry historyEntry : historyEntries) {
            this.historyMap.put(historyEntry.getId(), historyEntry);
        }
    }

    @NotNull
    public List<HistoryEntry> getHistory() {
        return new ArrayList<HistoryEntry>(this.historyMap.values());
    }

    @NotNull
    public HistoryEntry lastHistory() throws ResultException {
        if (this.historyMap.isEmpty()) {
            throw new ResultException(Result.build(Error.INVALID_HISTORY_DATA));
        }
        return this.historyMap.get(this.historyMap.size());
    }

    @NotNull
    public HistoryEntry activeHistory() throws ResultException {
        for (Map.Entry<Integer, HistoryEntry> entry : this.historyMap.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            return entry.getValue();
        }
        throw new ResultException(Result.build(Error.INVALID_HISTORY_DATA));
    }

    @NotNull
    public HistoryEntry findHistory(int historyId) throws ResultException {
        if (!this.historyMap.containsKey(historyId)) {
            throw new ResultException(Result.build(Error.INVALID_HISTORY_DATA));
        }
        return this.historyMap.get(historyId);
    }

    public int getHistorySize() {
        return this.historyMap.size();
    }
}

