/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient;

import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import net.webpdf.wsclient.AbstractWebService;
import net.webpdf.wsclient.WebServiceType;
import net.webpdf.wsclient.documents.DocumentManager;
import net.webpdf.wsclient.documents.RestDocument;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.http.HttpMethod;
import net.webpdf.wsclient.http.HttpRestRequest;
import net.webpdf.wsclient.schema.beans.DocumentFileBean;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.RestSession;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.tools.SerializeHelper;
import org.apache.commons.codec.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestWebservice<T_OPERATION_TYPE>
extends AbstractWebService<RestDocument, T_OPERATION_TYPE, RestDocument> {
    RestWebservice(@NotNull Session session, @NotNull WebServiceType webServiceType) {
        super(webServiceType, session);
    }

    @Override
    @Nullable
    public RestDocument process() throws ResultException {
        if (this.document == null) {
            return null;
        }
        String urlPath = this.webServiceType.equals((Object)WebServiceType.URLCONVERTER) ? this.webServiceType.getRestEndpoint() : this.webServiceType.getRestEndpoint().replace("{documentId}", ((RestDocument)this.document).getSourceDocumentId() != null ? ((RestDocument)this.document).getSourceDocumentId() : "");
        DocumentManager documentManager = ((RestSession)this.session).getDocumentManager();
        DocumentFileBean documentFileBean = HttpRestRequest.createRequest((RestSession)this.session).buildRequest(HttpMethod.POST, urlPath, this.getWebServiceOptions()).executeRequest(DocumentFileBean.class);
        RestDocument restDocument = documentManager.getDocument(documentFileBean);
        restDocument.setDocumentFile(documentFileBean);
        if (documentFileBean != null && documentManager.isUseHistory()) {
            String documentId = documentFileBean.getDocumentId() == null ? "" : documentFileBean.getDocumentId();
            documentManager.updateHistoryForDocument(documentId);
        }
        return restDocument;
    }

    @NotNull
    private HttpEntity getWebServiceOptions() throws ResultException {
        try {
            StringEntity stringEntity = new StringEntity(this.session.getDataFormat() == DataFormat.XML ? SerializeHelper.toXML(this.operation, this.operation.getClass()) : SerializeHelper.toJSON(this.operation), Charsets.UTF_8);
            if (this.session.getDataFormat() != null) {
                stringEntity.setContentType(this.session.getDataFormat().getMimeType());
            }
            return stringEntity;
        }
        catch (IOException | UnsupportedCharsetException ex) {
            throw new ResultException(Result.build(Error.TO_XML_JSON, ex));
        }
    }
}

