
package net.webpdf.wsclient.schema.extraction.info;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for BoxSelectionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="BoxSelectionType"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="mediaBox"/&gt;
 *     &lt;enumeration value="cropBox"/&gt;
 *     &lt;enumeration value="bleedBox"/&gt;
 *     &lt;enumeration value="trimBox"/&gt;
 *     &lt;enumeration value="artBox"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "BoxSelectionType")
@XmlEnum
public enum BoxSelectionType {

    @XmlEnumValue("mediaBox")
    MEDIA_BOX("mediaBox"),
    @XmlEnumValue("cropBox")
    CROP_BOX("cropBox"),
    @XmlEnumValue("bleedBox")
    BLEED_BOX("bleedBox"),
    @XmlEnumValue("trimBox")
    TRIM_BOX("trimBox"),
    @XmlEnumValue("artBox")
    ART_BOX("artBox");
    private final String value;

    BoxSelectionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static BoxSelectionType fromValue(String v) {
        for (BoxSelectionType c: BoxSelectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
