/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session;

import java.io.IOException;
import java.net.URL;
import net.webpdf.wsclient.WebServiceProtocol;
import net.webpdf.wsclient.documents.DocumentManager;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.http.HttpMethod;
import net.webpdf.wsclient.http.HttpRestRequest;
import net.webpdf.wsclient.https.TLSContext;
import net.webpdf.wsclient.proxy.ProxyConfiguration;
import net.webpdf.wsclient.schema.beans.Token;
import net.webpdf.wsclient.schema.beans.User;
import net.webpdf.wsclient.session.AbstractSession;
import net.webpdf.wsclient.session.DataFormat;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestSession
extends AbstractSession {
    private static final String INFO_PATH = "authentication/user/info/";
    private static final String LOGOUT_PATH = "authentication/user/logout/";
    private static final String LOGIN_PATH = "authentication/user/login/";
    @NotNull
    private final HttpClientBuilder httpClientBuilder;
    @NotNull
    private final DocumentManager documentManager = new DocumentManager(this);
    @Nullable
    private Token token;
    @Nullable
    private User user;
    @Nullable
    private CloseableHttpClient httpClient;

    RestSession(@NotNull URL url, @Nullable TLSContext tlsContext) throws ResultException {
        super(url, WebServiceProtocol.REST, tlsContext);
        this.dataFormat = DataFormat.JSON;
        RequestConfig clientConfig = RequestConfig.custom().setAuthenticationEnabled(true).build();
        this.httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(clientConfig).setDefaultCredentialsProvider(this.credentialsProvider);
        if (this.getTlsContext() != null) {
            this.httpClientBuilder.setSSLContext(this.getTlsContext().getSslContext());
        }
    }

    @Nullable
    public Token getToken() {
        return this.token;
    }

    @Override
    public void setProxy(@Nullable ProxyConfiguration proxy) throws ResultException {
        super.setProxy(proxy);
        if (proxy != null) {
            this.httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy.getHost()));
        }
    }

    @NotNull
    public CloseableHttpClient getHttpClient() {
        return this.httpClient == null ? (this.httpClient = this.httpClientBuilder.build()) : this.httpClient;
    }

    @NotNull
    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDataFormat(@Nullable DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.token != null && !this.token.getToken().isEmpty()) {
                this.logout();
            }
        }
        catch (ResultException ex) {
            throw new IOException("Unable to logout from server", ex);
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
    }

    public void login(@Nullable Token token) throws IOException {
        this.token = token;
        try {
            this.token = HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, LOGIN_PATH, null).executeRequest(Token.class);
            this.user = HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, INFO_PATH, null).executeRequest(User.class);
            if (token != null) {
                this.documentManager.sync();
            }
        }
        catch (IOException ex) {
            this.token = null;
            throw ex;
        }
    }

    public void login() throws IOException {
        this.login(null);
    }

    private void logout() throws IOException {
        HttpRestRequest.createRequest(this).buildRequest(HttpMethod.GET, LOGOUT_PATH, null).executeRequest(Object.class);
        this.token = null;
        this.user = null;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }
}

