/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import net.webpdf.wsclient.WebServiceProtocol;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.https.TLSContext;
import net.webpdf.wsclient.proxy.ProxyConfiguration;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.Session;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSession
implements Session {
    @NotNull
    CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    @Nullable
    DataFormat dataFormat = DataFormat.JSON;
    @NotNull
    private String basePath;
    @NotNull
    private WebServiceProtocol webServiceProtocol;
    @NotNull
    private URI baseUrl;
    @Nullable
    private AuthScope authScope;
    @Nullable
    private Credentials credentials;
    @Nullable
    private TLSContext tlsContext;
    @Nullable
    private ProxyConfiguration proxy;

    AbstractSession(@NotNull URL url, @NotNull WebServiceProtocol webServiceProtocol, @Nullable TLSContext tlsContext) throws ResultException {
        this.webServiceProtocol = webServiceProtocol;
        this.tlsContext = tlsContext;
        this.basePath = webServiceProtocol.equals((Object)WebServiceProtocol.SOAP) ? "soap/" : "rest/";
        String toUrl = url.toString();
        if (!toUrl.endsWith("/")) {
            toUrl = toUrl + "/";
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(toUrl);
            String userInfo = uriBuilder.getUserInfo();
            this.baseUrl = uriBuilder.setUserInfo(null).build();
            this.authScope = new AuthScope(this.baseUrl.getHost(), this.baseUrl.getPort());
            if (userInfo != null) {
                this.extractUserInfo(userInfo);
            }
            if (this.credentials != null) {
                this.credentialsProvider.setCredentials(this.authScope, this.credentials);
            }
        }
        catch (URISyntaxException ex) {
            throw new ResultException(Result.build(Error.INVALID_URL, ex));
        }
    }

    @Override
    @Nullable
    public TLSContext getTlsContext() {
        return this.tlsContext;
    }

    @Override
    @Nullable
    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(@Nullable ProxyConfiguration proxy) throws ResultException {
        this.proxy = proxy;
    }

    @Override
    @NotNull
    public WebServiceProtocol getWebServiceProtocol() {
        return this.webServiceProtocol;
    }

    private void extractUserInfo(@Nullable String userInfo) {
        String name = "";
        String password = "";
        if (userInfo != null) {
            String[] credentials = userInfo.split(":");
            if (credentials.length >= 1) {
                name = credentials[0];
            }
            if (credentials.length >= 2) {
                password = credentials[1];
            }
        }
        this.credentials = new UsernamePasswordCredentials(name, password);
    }

    @Override
    @NotNull
    public URI getURI(@NotNull String subPath) throws ResultException {
        try {
            return new URIBuilder(this.baseUrl).setPath(this.baseUrl.getPath() + this.basePath + subPath).build();
        }
        catch (URISyntaxException ex) {
            throw new ResultException(Result.build(Error.INVALID_URL, ex));
        }
    }

    @NotNull
    public URI getURI(@NotNull String subPath, List<NameValuePair> parameters) throws ResultException {
        try {
            return new URIBuilder(this.baseUrl).setPath(this.baseUrl.getPath() + this.basePath + subPath).addParameters(parameters).build();
        }
        catch (URISyntaxException ex) {
            throw new ResultException(Result.build(Error.INVALID_URL, ex));
        }
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(@Nullable Credentials credentials) {
        if (credentials != null) {
            this.credentials = credentials;
            this.credentialsProvider.setCredentials(this.authScope, this.credentials);
        }
    }

    @Override
    @Nullable
    public DataFormat getDataFormat() {
        return this.dataFormat;
    }
}

