/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.http.HttpMethod;
import net.webpdf.wsclient.schema.beans.ExceptionBean;
import net.webpdf.wsclient.schema.stubs.FaultInfo;
import net.webpdf.wsclient.schema.stubs.WebserviceException;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.RestSession;
import net.webpdf.wsclient.tools.SerializeHelper;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRestRequest {
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private final RestSession session;
    @Nullable
    private final DataFormat dataFormat;
    @Nullable
    private String acceptHeader;
    @Nullable
    private HttpUriRequest httpUriRequest;

    private HttpRestRequest(@NotNull RestSession session) {
        this.session = session;
        this.httpClient = session.getHttpClient();
        this.acceptHeader = session.getDataFormat() != null ? session.getDataFormat().getMimeType() : null;
        this.dataFormat = session.getDataFormat();
    }

    @NotNull
    public static HttpRestRequest createRequest(@NotNull RestSession session) {
        return new HttpRestRequest(session);
    }

    @NotNull
    public HttpRestRequest setAcceptHeader(@NotNull String mimeType) {
        this.acceptHeader = mimeType;
        return this;
    }

    @NotNull
    public HttpRestRequest buildRequest(@Nullable HttpMethod httpMethod, @Nullable String path, @Nullable HttpEntity httpEntity) throws ResultException {
        URI uri = this.session.getURI(path != null ? path : "");
        return this.buildRequest(httpMethod, uri, httpEntity);
    }

    @NotNull
    public HttpRestRequest buildRequest(@Nullable HttpMethod httpMethod, @Nullable URI uri, @Nullable HttpEntity httpEntity) throws ResultException {
        RequestBuilder requestBuilder;
        if (httpMethod == null) {
            throw new ResultException(Result.build(Error.UNKNOWN_HTTP_METHOD));
        }
        if (uri == null) {
            uri = this.session.getURI("");
        }
        switch (httpMethod) {
            case GET: {
                requestBuilder = RequestBuilder.get((URI)uri);
                break;
            }
            case POST: {
                requestBuilder = RequestBuilder.post((URI)uri);
                break;
            }
            case DELETE: {
                requestBuilder = RequestBuilder.delete((URI)uri);
                break;
            }
            case PUT: {
                requestBuilder = RequestBuilder.put((URI)uri);
                break;
            }
            default: {
                throw new ResultException(Result.build(Error.UNKNOWN_HTTP_METHOD));
            }
        }
        if (this.session.getCredentials() != null) {
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])(this.session.getCredentials().getUserPrincipal().getName() + ":" + this.session.getCredentials().getPassword()).getBytes(StandardCharsets.ISO_8859_1));
            requestBuilder.addHeader("Authorization", basicAuth);
        }
        requestBuilder.addHeader("Accept", this.acceptHeader);
        requestBuilder.setCharset(StandardCharsets.UTF_8);
        if (this.session.getToken() != null && !this.session.getToken().getToken().isEmpty()) {
            requestBuilder.addHeader("Token", this.session.getToken().getToken());
        }
        if (httpEntity != null) {
            requestBuilder.setEntity(httpEntity);
        }
        this.httpUriRequest = requestBuilder.build();
        return this;
    }

    private void checkResponse(@NotNull HttpResponse httpResponse) throws ResultException {
        String responseOutput;
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() == 200) {
            return;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            throw new ResultException(Result.build(Error.HTTP_EMPTY_ENTITY));
        }
        Header header = httpEntity.getContentType();
        if (header != null && (header.getValue().equals(DataFormat.XML.getMimeType()) || header.getValue().equals(DataFormat.JSON.getMimeType()))) {
            ExceptionBean exceptionBean = DataFormat.XML.equals((Object)this.dataFormat) ? SerializeHelper.fromXML(httpEntity, ExceptionBean.class) : SerializeHelper.fromJSON(httpEntity, ExceptionBean.class);
            responseOutput = "Server error: " + exceptionBean.getErrorMessage() + " (" + exceptionBean.getErrorCode() + ")\n" + (exceptionBean.getStackTrace() != null && !exceptionBean.getStackTrace().isEmpty() ? "Server stack trace: " + exceptionBean.getStackTrace() + "\n" : "");
            if (exceptionBean.getErrorCode() != 0) {
                FaultInfo faultInfo = new FaultInfo();
                faultInfo.setErrorMessage(exceptionBean.getErrorMessage());
                faultInfo.setErrorCode(exceptionBean.getErrorCode());
                faultInfo.setStackTrace(exceptionBean.getStackTrace());
                throw new ResultException(Result.build(Error.REST_EXECUTION, new WebserviceException(responseOutput, faultInfo)));
            }
        } else {
            try {
                responseOutput = EntityUtils.toString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                throw new ResultException(Result.build(Error.HTTP_CUSTOM_ERROR, ex));
            }
        }
        throw new ResultException(Result.build(Error.HTTP_CUSTOM_ERROR).addMessage(statusLine.getStatusCode() + " " + statusLine.getReasonPhrase() + "\n" + responseOutput));
    }

    public void executeRequest(@Nullable OutputStream outputStream) throws ResultException {
        if (outputStream == null) {
            throw new ResultException(Result.build(Error.INVALID_FILE_SOURCE));
        }
        try (CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(this.httpUriRequest);){
            closeableHttpResponse.getEntity().writeTo(outputStream);
        }
        catch (IOException ex) {
            throw new ResultException(Result.build(Error.HTTP_IO_ERROR, ex));
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <T> T executeRequest(@Nullable Class<T> type) throws ResultException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

