/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.exception;

import java.util.ArrayList;
import java.util.List;
import net.webpdf.wsclient.exception.Error;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Result {
    @NotNull
    private Error error;
    @Nullable
    private Exception exception;
    @NotNull
    private List<String> messages = new ArrayList<String>();
    private int exitCode;

    private Result(@NotNull Error error, int exitCode, @Nullable Exception exception) {
        this.error = error;
        this.exitCode = exitCode;
        this.exception = exception;
    }

    public static Result build(@NotNull Error error) {
        return new Result(error, 0, null);
    }

    public static Result build(@NotNull Error error, int exitCode) {
        return new Result(error, exitCode, null);
    }

    public static Result build(@NotNull Error error, @Nullable Exception exception) {
        return new Result(error, 0, exception);
    }

    public boolean isError() {
        return !Error.NONE.equals((Object)this.error);
    }

    boolean isSuccess() {
        return Error.NONE.equals((Object)this.error);
    }

    boolean equalsError(@Nullable Error error) {
        return this.error.equals((Object)error);
    }

    @NotNull
    public Error getError() {
        return this.error;
    }

    public int getCode() {
        return this.error.getCode();
    }

    @NotNull
    public String getMessage() {
        String errorMessage = this.error.getMessage();
        String detailMessage = StringUtils.join(this.messages, (String)"\n");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(errorMessage);
        stringBuilder.append(!detailMessage.isEmpty() && stringBuilder.length() > 0 ? "\n" : "");
        stringBuilder.append(detailMessage);
        if (this.exitCode != 0) {
            stringBuilder.append(stringBuilder.length() > 0 ? " " : "");
            stringBuilder.append("[").append(this.exitCode).append("]");
        }
        return stringBuilder.toString();
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    @NotNull
    public Result addMessage(@Nullable String message) {
        if (message != null && !message.isEmpty()) {
            this.messages.add(StringUtils.capitalize((String)message));
        }
        return this;
    }
}

