/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.documents;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.webpdf.wsclient.documents.RestDocument;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.Result;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.http.HttpMethod;
import net.webpdf.wsclient.http.HttpRestRequest;
import net.webpdf.wsclient.schema.beans.DocumentFileBean;
import net.webpdf.wsclient.schema.beans.HistoryEntry;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.RestSession;
import net.webpdf.wsclient.tools.SerializeHelper;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentManager {
    @NotNull
    private final ConcurrentHashMap<String, RestDocument> documentMap = new ConcurrentHashMap();
    @NotNull
    private final RestSession session;
    private boolean useHistory = false;

    public DocumentManager(@NotNull RestSession session) {
        this.session = session;
    }

    @Deprecated
    public void downloadDocument(@Nullable RestDocument document, @Nullable OutputStream outputStream) throws ResultException {
        if (document == null || outputStream == null) {
            throw new ResultException(Result.build(Error.INVALID_FILE_SOURCE));
        }
        String documentId = document.getSourceDocumentId();
        if (!this.containsDocument(documentId)) {
            throw new ResultException(Result.build(Error.INVALID_DOCUMENT));
        }
        this.downloadDocument(documentId, outputStream);
    }

    public void downloadDocument(@NotNull String documentId, @Nullable OutputStream outputStream) throws ResultException {
        if (!this.containsDocument(documentId)) {
            throw new ResultException(Result.build(Error.INVALID_FILE_SOURCE));
        }
        HttpRestRequest.createRequest(this.session).setAcceptHeader("application/octet-stream").buildRequest(HttpMethod.GET, "documents/" + documentId, null).executeRequest(outputStream);
    }

    @NotNull
    public RestDocument uploadDocument(@Nullable File file) throws IOException {
        if (file == null) {
            throw new ResultException(Result.build(Error.INVALID_FILE_SOURCE));
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(StandardCharsets.UTF_8);
        builder.addBinaryBody("filedata", file, ContentType.DEFAULT_BINARY, file.getName());
        HttpEntity entity = builder.build();
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("history", Boolean.toString(this.useHistory)));
        URI uri = this.session.getURI("documents", parameters);
        DocumentFileBean documentFileBean = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, uri, entity).executeRequest(DocumentFileBean.class);
        return this.createRestDocument(documentFileBean);
    }

    private RestDocument createRestDocument(@Nullable DocumentFileBean documentFileBean) throws ResultException {
        if (documentFileBean == null || documentFileBean.getDocumentId() == null) {
            throw new ResultException(Result.build(Error.INVALID_DOCUMENT));
        }
        RestDocument restDocument = new RestDocument(documentFileBean.getDocumentId());
        restDocument.setDocumentFile(documentFileBean);
        if (this.useHistory) {
            this.fetchHistoryForDocument(restDocument);
        }
        this.documentMap.put(documentFileBean.getDocumentId(), restDocument);
        return restDocument;
    }

    @NotNull
    public RestDocument findDocument(@NotNull String documentId) throws ResultException {
        if (!this.containsDocument(documentId)) {
            throw new ResultException(Result.build(Error.INVALID_DOCUMENT));
        }
        return this.documentMap.get(documentId);
    }

    public boolean hasDocument(@NotNull String documentId) {
        return this.containsDocument(documentId);
    }

    @Deprecated
    @NotNull
    public RestDocument getDocument(@Nullable DocumentFileBean documentFileBean) throws ResultException {
        String documentID = this.getDocumentID(documentFileBean);
        if (this.containsDocument(documentID)) {
            return this.documentMap.get(documentID);
        }
        return this.createRestDocument(documentFileBean);
    }

    public void deleteDocument(@NotNull String documentId) throws ResultException {
        if (!this.containsDocument(documentId)) {
            throw new ResultException(Result.build(Error.INVALID_DOCUMENT));
        }
        HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.DELETE, "documents/" + documentId, null).executeRequest(Object.class);
        this.documentMap.remove(documentId);
    }

    @NotNull
    public RestDocument renameDocument(@NotNull String documentId, @Nullable String fileName) throws IOException {
        RestDocument restDocument = this.findDocument(documentId);
        DocumentFileBean documentFileBean = new DocumentFileBean();
        documentFileBean.setFileName(fileName);
        DocumentFileBean documentFile = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.POST, "documents/" + documentId + "/update", this.getWebServiceOptions(documentFileBean)).executeRequest(DocumentFileBean.class);
        restDocument.setDocumentFile(documentFile);
        return restDocument;
    }

    public void updateHistoryForDocument(@NotNull String documentId) throws ResultException {
        RestDocument restDocument = this.findDocument(documentId);
        this.fetchHistoryForDocument(restDocument);
    }

    private void fetchHistoryForDocument(@NotNull RestDocument restDocument) throws ResultException {
        HistoryEntry[] history = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "documents/" + restDocument.getSourceDocumentId() + "/history", null).executeRequest(HistoryEntry[].class);
        if (history == null) {
            throw new ResultException(Result.build(Error.INVALID_HISTORY_DATA));
        }
        restDocument.storeHistory(history);
    }

    public RestDocument activateHistory(@NotNull String documentId, int historyId) throws ResultException {
        HistoryEntry historyEntry = new HistoryEntry();
        historyEntry.setId(historyId);
        historyEntry.setActive(true);
        return this.setDocumentHistoryElement(documentId, historyEntry);
    }

    public RestDocument updateHistoryOperation(@NotNull String documentId, int historyId, @NotNull String operation) throws ResultException {
        HistoryEntry historyEntry = new HistoryEntry();
        historyEntry.setId(historyId);
        historyEntry.setOperation(StringUtils.isEmpty((CharSequence)operation) ? "" : operation);
        return this.setDocumentHistoryElement(documentId, historyEntry);
    }

    @NotNull
    private RestDocument setDocumentHistoryElement(@NotNull String documentId, @NotNull HistoryEntry historyEntry) throws ResultException {
        if (!this.useHistory) {
            throw new ResultException(Result.build(Error.INVALID_HISTORY_DATA));
        }
        if (!this.containsDocument(documentId)) {
            throw new ResultException(Result.build(Error.INVALID_DOCUMENT));
        }
        RestDocument restDocument = this.documentMap.get(documentId);
        int historyId = historyEntry.getId();
        HistoryEntry resultHistoryBean = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.PUT, "documents/" + documentId + "/history/" + historyId, this.getWebServiceOptions(historyEntry)).executeRequest(HistoryEntry.class);
        restDocument = this.updateDocument(restDocument.getDocumentFile());
        restDocument.replaceHistoryEntry(resultHistoryBean);
        return restDocument;
    }

    @NotNull
    private RestDocument updateDocument(@Nullable DocumentFileBean documentFileBean) throws ResultException {
        String documentId = this.getContainedDocumentID(documentFileBean);
        DocumentFileBean documentFile = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "documents/" + documentId + "/info", null).executeRequest(DocumentFileBean.class);
        RestDocument restDocument = this.documentMap.get(documentId);
        restDocument.setDocumentFile(documentFile);
        return restDocument;
    }

    public void sync() throws ResultException {
        DocumentFileBean[] documentFileList = HttpRestRequest.createRequest(this.session).buildRequest(HttpMethod.GET, "documents/list", null).executeRequest(DocumentFileBean[].class);
        if (documentFileList == null) {
            throw new ResultException(Result.build(Error.HTTP_IO_ERROR));
        }
        this.documentMap.clear();
        for (DocumentFileBean documentFile : documentFileList) {
            String documentId = documentFile.getDocumentId();
            if (StringUtils.isEmpty((CharSequence)documentId)) continue;
            this.createRestDocument(documentFile);
        }
    }

    @NotNull
    public List<RestDocument> getDocuments() {
        return new ArrayList<RestDocument>(this.documentMap.values());
    }

    @NotNull
    private <T> HttpEntity getWebServiceOptions(@Nullable T parameter) throws ResultException {
        try {
            if (parameter == null) {
                throw new ResultException(Result.build(Error.NO_OPERATION_DATA));
            }
            StringEntity stringEntity = new StringEntity(this.session.getDataFormat() == DataFormat.XML ? SerializeHelper.toXML(parameter, parameter.getClass()) : SerializeHelper.toJSON(parameter), Charsets.UTF_8);
            if (this.session.getDataFormat() != null) {
                stringEntity.setContentType(this.session.getDataFormat().getMimeType());
            }
            return stringEntity;
        }
        catch (IOException | UnsupportedCharsetException ex) {
            throw new ResultException(Result.build(Error.TO_XML_JSON, ex));
        }
    }

    public boolean isUseHistory() {
        return this.useHistory;
    }

    public void setUseHistory(boolean useHistory) {
        this.useHistory = useHistory;
    }

    private boolean containsDocument(@Nullable String documentId) {
        return documentId != null && this.documentMap.containsKey(documentId);
    }

    @NotNull
    private String getContainedDocumentID(@Nullable DocumentFileBean document) throws ResultException {
        String id = this.getDocumentID(document);
        if (this.containsDocument(id)) {
            return id;
        }
        throw new ResultException(Result.build(Error.INVALID_DOCUMENT));
    }

    @NotNull
    private String getDocumentID(@Nullable DocumentFileBean document) throws ResultException {
        if (document != null && document.getDocumentId() != null) {
            return document.getDocumentId();
        }
        throw new ResultException(Result.build(Error.INVALID_DOCUMENT));
    }
}

