/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.webpdf.wsclient.WebService;
import net.webpdf.wsclient.WebServiceType;
import net.webpdf.wsclient.documents.Document;
import net.webpdf.wsclient.schema.operation.BillingType;
import net.webpdf.wsclient.schema.operation.OperationData;
import net.webpdf.wsclient.schema.operation.PdfPasswordType;
import net.webpdf.wsclient.session.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractWebService<T_DOC extends Document, T_OPERATION_TYPE, T_RESULT>
implements WebService<T_DOC, T_OPERATION_TYPE, T_RESULT> {
    @NotNull
    final WebServiceType webServiceType;
    @NotNull
    final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    @NotNull
    final Session session;
    @NotNull
    OperationData operation = new OperationData();
    @Nullable
    T_DOC document;

    AbstractWebService(@NotNull WebServiceType webServiceType, @NotNull Session session) {
        this.session = session;
        this.webServiceType = webServiceType;
        this.operation.setBilling(new BillingType());
        this.operation.setPassword(new PdfPasswordType());
        this.initOperation(this.operation);
    }

    @Override
    @Nullable
    public T_DOC getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(@Nullable T_DOC document) {
        this.document = document;
    }

    @Override
    @NotNull
    public BillingType getBilling() {
        return this.operation.getBilling();
    }

    @Override
    @NotNull
    public PdfPasswordType getPassword() {
        return this.operation.getPassword();
    }

    protected abstract void initOperation(@NotNull OperationData var1);
}

