
package net.webpdf.wsclient.schema.extraction.info;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PageLayoutType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="PageLayoutType"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="singlePage"/&gt;
 *     &lt;enumeration value="oneColumn"/&gt;
 *     &lt;enumeration value="twoColumnLeft"/&gt;
 *     &lt;enumeration value="twoColumnRight"/&gt;
 *     &lt;enumeration value="twoPageLeft"/&gt;
 *     &lt;enumeration value="twoPageRight"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "PageLayoutType")
@XmlEnum
public enum PageLayoutType {

    @XmlEnumValue("singlePage")
    SINGLE_PAGE("singlePage"),
    @XmlEnumValue("oneColumn")
    ONE_COLUMN("oneColumn"),
    @XmlEnumValue("twoColumnLeft")
    TWO_COLUMN_LEFT("twoColumnLeft"),
    @XmlEnumValue("twoColumnRight")
    TWO_COLUMN_RIGHT("twoColumnRight"),
    @XmlEnumValue("twoPageLeft")
    TWO_PAGE_LEFT("twoPageLeft"),
    @XmlEnumValue("twoPageRight")
    TWO_PAGE_RIGHT("twoPageRight");
    private final String value;

    PageLayoutType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PageLayoutType fromValue(String v) {
        for (PageLayoutType c: PageLayoutType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
