/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.webservice.soap;

import jakarta.activation.DataHandler;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.soap.MTOMFeature;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.exception.ServerResultException;
import net.webpdf.wsclient.schema.operation.BillingType;
import net.webpdf.wsclient.schema.operation.OperationData;
import net.webpdf.wsclient.schema.operation.PdfPasswordType;
import net.webpdf.wsclient.schema.operation.SettingsType;
import net.webpdf.wsclient.schema.stubs.WebServiceException;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.auth.material.AuthMaterial;
import net.webpdf.wsclient.session.soap.SoapSession;
import net.webpdf.wsclient.session.soap.documents.SoapDocument;
import net.webpdf.wsclient.webservice.AbstractWebService;
import net.webpdf.wsclient.webservice.WebServiceType;
import net.webpdf.wsclient.webservice.soap.ConverterWebService;
import org.apache.hc.client5.http.auth.Credentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SoapWebService<T_WEBPDF_PORT, T_OPERATION_PARAMETER, T_SOAP_DOCUMENT extends SoapDocument>
extends AbstractWebService<SoapSession<T_SOAP_DOCUMENT>, OperationData, T_OPERATION_PARAMETER, T_SOAP_DOCUMENT, BillingType, PdfPasswordType, SettingsType> {
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    @NotNull
    private final MTOMFeature feature = new MTOMFeature();
    @NotNull
    private final QName qname;
    @NotNull
    private final URI webserviceURL;
    @NotNull
    private final T_WEBPDF_PORT port;

    public SoapWebService(@NotNull SoapSession<T_SOAP_DOCUMENT> session, @NotNull WebServiceType webServiceType) throws ResultException {
        super(webServiceType, session);
        this.qname = new QName(webServiceType.getSoapNamespaceURI(), webServiceType.getSoapLocalPart());
        this.webserviceURL = ((SoapSession)this.getSession()).getURI(webServiceType.getSoapEndpoint());
        this.port = this.provideWebServicePort();
    }

    @Override
    @NotNull
    public T_SOAP_DOCUMENT process() throws ResultException {
        return this.process((T_SOAP_DOCUMENT)((SoapSession)this.getSession()).createDocument());
    }

    @Override
    @NotNull
    public T_SOAP_DOCUMENT process(@NotNull T_SOAP_DOCUMENT sourceDocument) throws ResultException {
        try {
            this.applyOptions();
            sourceDocument.setResult(this.processService(sourceDocument));
            return sourceDocument;
        }
        catch (WebServiceException ex) {
            throw new ServerResultException(ex);
        }
        catch (Exception ex) {
            throw new ClientResultException(Error.SOAP_EXECUTION, ex);
        }
    }

    @Override
    @NotNull
    public PdfPasswordType getPassword() {
        return ((OperationData)this.getOperationData()).getPassword();
    }

    @Override
    public void setPassword(@Nullable PdfPasswordType password) {
        ((OperationData)this.getOperationData()).setPassword(password);
    }

    @Override
    @NotNull
    public BillingType getBilling() {
        return ((OperationData)this.getOperationData()).getBilling();
    }

    @Override
    public void setBilling(@Nullable BillingType billing) {
        ((OperationData)this.getOperationData()).setBilling(billing);
    }

    @Override
    @Nullable
    public SettingsType getSettings() {
        return ((OperationData)this.getOperationData()).getSettings();
    }

    @Override
    public void setSettings(@Nullable SettingsType settings) {
        ((OperationData)this.getOperationData()).setSettings(settings);
    }

    @Nullable
    protected abstract DataHandler processService(@NotNull T_SOAP_DOCUMENT var1) throws WebServiceException;

    @NotNull
    protected QName getQName() {
        return this.qname;
    }

    @NotNull
    protected URL getWsdlDocumentLocation() throws ResultException {
        boolean useLocalWsdl = ((SoapSession)this.getSession()).isUseLocalWsdl();
        try {
            URL url;
            URL uRL = url = useLocalWsdl ? ConverterWebService.class.getClassLoader().getResource("wsdl/" + this.getWebServiceType().getSoapEndpoint() + ".wsdl") : this.webserviceURL.toURL();
            if (url == null) {
                throw new ClientResultException(Error.WSDL_INVALID_FILE);
            }
            return url;
        }
        catch (MalformedURLException ex) {
            throw new ClientResultException(Error.WSDL_INVALID_URL, ex);
        }
    }

    @NotNull
    protected MTOMFeature getMTOMFeature() {
        return this.feature;
    }

    private void applyOptions() throws ResultException {
        BindingProvider bindingProvider = (BindingProvider)this.port;
        AuthMaterial authMaterial = ((SoapSession)this.getSession()).getAuthProvider().provide((Session)this.getSession());
        String authorizationHeader = authMaterial.getRawAuthHeader();
        if (authorizationHeader != null) {
            this.getHeaders().put("Authorization", Collections.singletonList(authorizationHeader));
            if (!this.getHeaders().isEmpty()) {
                Map requestContext = bindingProvider.getRequestContext();
                requestContext.put("jakarta.xml.ws.http.request.headers", this.getHeaders());
                Credentials credentials = authMaterial.getCredentials();
                if (credentials != null) {
                    requestContext.put("jakarta.xml.ws.security.auth.username", credentials.getUserPrincipal().getName());
                    requestContext.put("jakarta.xml.ws.security.auth.password", new String(credentials.getPassword()));
                }
            }
        }
        bindingProvider.getRequestContext().put("jakarta.xml.ws.service.endpoint.address", this.webserviceURL.toString());
        if (((SoapSession)this.getSession()).getSessionContext().getTlsContext() != null) {
            bindingProvider.getRequestContext().put(SSL_SOCKET_FACTORY, ((SoapSession)this.getSession()).getSessionContext().getTlsContext().create().getSocketFactory());
        }
    }

    @NotNull
    protected abstract T_WEBPDF_PORT provideWebServicePort() throws ResultException;

    @NotNull
    protected T_WEBPDF_PORT getPort() {
        return this.port;
    }
}

