/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.tools;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.ValidationEventLocator;
import java.util.ArrayList;
import java.util.List;
import net.webpdf.wsclient.tools.XMLStatus;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XMLValidationEventHandler
implements ValidationEventHandler {
    @NotNull
    private final List<String> messages = new ArrayList<String>();
    @NotNull
    private XMLStatus xmlStatus = XMLStatus.OK;

    XMLValidationEventHandler() {
    }

    boolean isValid() {
        return this.xmlStatus.equals((Object)XMLStatus.OK);
    }

    public boolean handleEvent(@Nullable ValidationEvent event) {
        if (event == null) {
            return false;
        }
        XMLStatus status = XMLStatus.OK;
        switch (event.getSeverity()) {
            case 0: {
                status = XMLStatus.WARNING;
                break;
            }
            case 1: {
                status = XMLStatus.ERROR;
                break;
            }
            case 2: {
                status = XMLStatus.FATAL;
            }
        }
        if (status.ordinal() > this.xmlStatus.ordinal()) {
            this.xmlStatus = status;
        }
        Object message = event.getMessage() != null ? event.getMessage() : "";
        ValidationEventLocator validationEventLocator = event.getLocator();
        if (validationEventLocator != null) {
            message = (String)message + String.format(" (line: %d; column: %d)", validationEventLocator.getLineNumber(), validationEventLocator.getColumnNumber());
        }
        this.messages.add((String)message);
        return false;
    }

    @NotNull
    String getMessages() {
        return StringUtils.join(this.messages, (String)"\n");
    }

    @NotNull
    XMLStatus getXMLStatus() {
        return this.xmlStatus;
    }
}

