/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.SessionState;
import org.jetbrains.annotations.Nullable;

@Schema(description="Stores detailed information about a single session entry in the session table.")
@JsonPropertyOrder(value={"admin", "fileCount", "fileSize", "fileSizeHistory", "isAdmin", "lastAccess", "providerId", "sessionExpiration", "sessionId", "sessionState", "userName"})
@JsonTypeName(value="Session_TableEntry")
public class SessionTableEntry {
    public static final String JSON_PROPERTY_ADMIN = "admin";
    private Boolean admin = false;
    public static final String JSON_PROPERTY_FILE_COUNT = "fileCount";
    private Long fileCount = 0L;
    public static final String JSON_PROPERTY_FILE_SIZE = "fileSize";
    private Long fileSize = 0L;
    public static final String JSON_PROPERTY_FILE_SIZE_HISTORY = "fileSizeHistory";
    private Long fileSizeHistory = 0L;
    public static final String JSON_PROPERTY_IS_ADMIN = "isAdmin";
    private Boolean isAdmin = false;
    public static final String JSON_PROPERTY_LAST_ACCESS = "lastAccess";
    private Long lastAccess = 0L;
    public static final String JSON_PROPERTY_PROVIDER_ID = "providerId";
    private String providerId = "";
    public static final String JSON_PROPERTY_SESSION_EXPIRATION = "sessionExpiration";
    private Long sessionExpiration = 0L;
    public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
    private String sessionId = "";
    public static final String JSON_PROPERTY_SESSION_STATE = "sessionState";
    private SessionState sessionState = SessionState.UNKNOWN;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName = "";

    public SessionTableEntry admin(Boolean admin) {
        this.admin = admin;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAdmin() {
        return this.admin;
    }

    @JsonProperty(value="admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    public SessionTableEntry fileCount(Long fileCount) {
        this.fileCount = fileCount;
        return this;
    }

    @Schema(name="Number of files saved in the session.")
    @JsonProperty(value="fileCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getFileCount() {
        return this.fileCount;
    }

    @JsonProperty(value="fileCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileCount(Long fileCount) {
        this.fileCount = fileCount;
    }

    public SessionTableEntry fileSize(Long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    @Schema(name="Total size in bytes of all files saved in the session, excluding history entries.")
    @JsonProperty(value="fileSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty(value="fileSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public SessionTableEntry fileSizeHistory(Long fileSizeHistory) {
        this.fileSizeHistory = fileSizeHistory;
        return this;
    }

    @Schema(name="Total size in bytes of all history files stored in the session, except the active file entry.")
    @JsonProperty(value="fileSizeHistory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getFileSizeHistory() {
        return this.fileSizeHistory;
    }

    @JsonProperty(value="fileSizeHistory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileSizeHistory(Long fileSizeHistory) {
        this.fileSizeHistory = fileSizeHistory;
    }

    public SessionTableEntry isAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
        return this;
    }

    @Schema(name="Set if the user has administrator rights.")
    @JsonProperty(value="isAdmin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    @JsonProperty(value="isAdmin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public SessionTableEntry lastAccess(Long lastAccess) {
        this.lastAccess = lastAccess;
        return this;
    }

    @Schema(name="UTC time of the last access to the session.")
    @JsonProperty(value="lastAccess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getLastAccess() {
        return this.lastAccess;
    }

    @JsonProperty(value="lastAccess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastAccess(Long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public SessionTableEntry providerId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    @Schema(name="The ID of the external credential provider used to create the session. Empty if local provider was used.")
    @JsonProperty(value="providerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getProviderId() {
        return this.providerId;
    }

    @JsonProperty(value="providerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public SessionTableEntry sessionExpiration(Long sessionExpiration) {
        this.sessionExpiration = sessionExpiration;
        return this;
    }

    @Schema(name="Time in seconds when the session will expire.")
    @JsonProperty(value="sessionExpiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getSessionExpiration() {
        return this.sessionExpiration;
    }

    @JsonProperty(value="sessionExpiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionExpiration(Long sessionExpiration) {
        this.sessionExpiration = sessionExpiration;
    }

    public SessionTableEntry sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Schema(name="Unique id of the session.")
    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public SessionTableEntry sessionState(SessionState sessionState) {
        this.sessionState = sessionState;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="sessionState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @JsonProperty(value="sessionState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionState(SessionState sessionState) {
        this.sessionState = sessionState;
    }

    public SessionTableEntry userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(name="Username of the authenticated user or empty if unknown or it is an anonymous session.")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionTableEntry sessionTableEntry = (SessionTableEntry)o;
        return Objects.equals(this.admin, sessionTableEntry.admin) && Objects.equals(this.fileCount, sessionTableEntry.fileCount) && Objects.equals(this.fileSize, sessionTableEntry.fileSize) && Objects.equals(this.fileSizeHistory, sessionTableEntry.fileSizeHistory) && Objects.equals(this.isAdmin, sessionTableEntry.isAdmin) && Objects.equals(this.lastAccess, sessionTableEntry.lastAccess) && Objects.equals(this.providerId, sessionTableEntry.providerId) && Objects.equals(this.sessionExpiration, sessionTableEntry.sessionExpiration) && Objects.equals(this.sessionId, sessionTableEntry.sessionId) && Objects.equals((Object)this.sessionState, (Object)sessionTableEntry.sessionState) && Objects.equals(this.userName, sessionTableEntry.userName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.admin, this.fileCount, this.fileSize, this.fileSizeHistory, this.isAdmin, this.lastAccess, this.providerId, this.sessionExpiration, this.sessionId, this.sessionState, this.userName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionTableEntry {\n");
        sb.append("    admin: ").append(this.toIndentedString(this.admin)).append("\n");
        sb.append("    fileCount: ").append(this.toIndentedString(this.fileCount)).append("\n");
        sb.append("    fileSize: ").append(this.toIndentedString(this.fileSize)).append("\n");
        sb.append("    fileSizeHistory: ").append(this.toIndentedString(this.fileSizeHistory)).append("\n");
        sb.append("    isAdmin: ").append(this.toIndentedString(this.isAdmin)).append("\n");
        sb.append("    lastAccess: ").append(this.toIndentedString(this.lastAccess)).append("\n");
        sb.append("    providerId: ").append(this.toIndentedString(this.providerId)).append("\n");
        sb.append("    sessionExpiration: ").append(this.toIndentedString(this.sessionExpiration)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    sessionState: ").append(this.toIndentedString((Object)this.sessionState)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

