/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines an Azure Active Directory as a user source.")
@JsonPropertyOrder(value={"authority", "clientId", "scope"})
@JsonTypeName(value="ServerConfig_UserAzureAd")
public class ServerConfigUserAzureAd {
    public static final String JSON_PROPERTY_AUTHORITY = "authority";
    private String authority = "https://login.microsoftonline.com/organizations/";
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId = "";
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope = "user.read";

    public ServerConfigUserAzureAd authority(String authority) {
        this.authority = authority;
        return this;
    }

    @Schema(name="Defines the URL to be used for logging in to Azure AD.")
    @JsonProperty(value="authority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    @JsonProperty(value="authority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public ServerConfigUserAzureAd clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(name="Defines the client (application) ID that is stored in the Azure AD in the application registration.")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ServerConfigUserAzureAd scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Schema(name="Defines the scope to be used when logging in to Anzure AD.")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigUserAzureAd serverConfigUserAzureAd = (ServerConfigUserAzureAd)o;
        return Objects.equals(this.authority, serverConfigUserAzureAd.authority) && Objects.equals(this.clientId, serverConfigUserAzureAd.clientId) && Objects.equals(this.scope, serverConfigUserAzureAd.scope);
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.clientId, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigUserAzureAd {\n");
        sb.append("    authority: ").append(this.toIndentedString(this.authority)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

