/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines proxy configuration for the connector.")
@JsonPropertyOrder(value={"host", "port", "scheme"})
@JsonTypeName(value="ServerConfig_Proxy")
public class ServerConfigProxy {
    public static final String JSON_PROPERTY_HOST = "host";
    private String host = "";
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port = 0;
    public static final String JSON_PROPERTY_SCHEME = "scheme";
    private String scheme = "http";

    public ServerConfigProxy host(String host) {
        this.host = host;
        return this;
    }

    @Schema(name="The proxy host's name.")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHost(String host) {
        this.host = host;
    }

    public ServerConfigProxy port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(name="The port on which the proxy listens.\".")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public ServerConfigProxy scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Schema(name="The protocol scheme for the proxy (e.g. \"http\" or \"https\").")
    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigProxy serverConfigProxy = (ServerConfigProxy)o;
        return Objects.equals(this.host, serverConfigProxy.host) && Objects.equals(this.port, serverConfigProxy.port) && Objects.equals(this.scheme, serverConfigProxy.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.scheme);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigProxy {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

