/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigHostFilterMapping;
import net.webpdf.wsclient.openapi.ServerConfigHostFilterParameter;
import org.jetbrains.annotations.Nullable;

@Schema(description="A `filter` element represents a component to insert into the request processing pipeline of the underlying Tomcat server. (See: https://tomcat.apache.org/tomcat-10.1-doc/config/filter.html for further information.)")
@JsonPropertyOrder(value={"className", "mapping", "parameter"})
@JsonTypeName(value="ServerConfig_HostFilter")
public class ServerConfigHostFilter {
    public static final String JSON_PROPERTY_CLASS_NAME = "className";
    private String className = "";
    public static final String JSON_PROPERTY_MAPPING = "mapping";
    private List<ServerConfigHostFilterMapping> mapping = null;
    public static final String JSON_PROPERTY_PARAMETER = "parameter";
    private List<ServerConfigHostFilterParameter> parameter = null;

    public ServerConfigHostFilter className(String className) {
        this.className = className;
        return this;
    }

    @Schema(name="The Java class name of the filter implementation to use.")
    @JsonProperty(value="className")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClassName() {
        return this.className;
    }

    @JsonProperty(value="className")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClassName(String className) {
        this.className = className;
    }

    public ServerConfigHostFilter mapping(List<ServerConfigHostFilterMapping> mapping) {
        this.mapping = mapping;
        return this;
    }

    public ServerConfigHostFilter addMappingItem(ServerConfigHostFilterMapping mappingItem) {
        if (this.mapping == null) {
            this.mapping = new ArrayList<ServerConfigHostFilterMapping>();
        }
        this.mapping.add(mappingItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="mapping")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ServerConfigHostFilterMapping> getMapping() {
        return this.mapping;
    }

    @JsonProperty(value="mapping")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMapping(List<ServerConfigHostFilterMapping> mapping) {
        this.mapping = mapping;
    }

    public ServerConfigHostFilter parameter(List<ServerConfigHostFilterParameter> parameter) {
        this.parameter = parameter;
        return this;
    }

    public ServerConfigHostFilter addParameterItem(ServerConfigHostFilterParameter parameterItem) {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ServerConfigHostFilterParameter>();
        }
        this.parameter.add(parameterItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="parameter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ServerConfigHostFilterParameter> getParameter() {
        return this.parameter;
    }

    @JsonProperty(value="parameter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameter(List<ServerConfigHostFilterParameter> parameter) {
        this.parameter = parameter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigHostFilter serverConfigHostFilter = (ServerConfigHostFilter)o;
        return Objects.equals(this.className, serverConfigHostFilter.className) && Objects.equals(this.mapping, serverConfigHostFilter.mapping) && Objects.equals(this.parameter, serverConfigHostFilter.parameter);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.mapping, this.parameter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigHostFilter {\n");
        sb.append("    className: ").append(this.toIndentedString(this.className)).append("\n");
        sb.append("    mapping: ").append(this.toIndentedString(this.mapping)).append("\n");
        sb.append("    parameter: ").append(this.toIndentedString(this.parameter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

