/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The rotate operation element can be used to rotate pages in the document.")
@JsonPropertyOrder(value={"degrees", "orientationDetectMode", "pageGroup", "pageOrientation", "pages"})
@JsonTypeName(value="Operation_ToolboxRotate_rotate")
public class OperationToolboxRotateRotate {
    public static final String JSON_PROPERTY_DEGREES = "degrees";
    private Integer degrees = 90;
    public static final String JSON_PROPERTY_ORIENTATION_DETECT_MODE = "orientationDetectMode";
    private OrientationDetectModeEnum orientationDetectMode = OrientationDetectModeEnum.VALUE;
    public static final String JSON_PROPERTY_PAGE_GROUP = "pageGroup";
    private PageGroupEnum pageGroup = PageGroupEnum.ALL;
    public static final String JSON_PROPERTY_PAGE_ORIENTATION = "pageOrientation";
    private PageOrientationEnum pageOrientation = PageOrientationEnum.ANY;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "1";

    public OperationToolboxRotateRotate degrees(Integer degrees) {
        this.degrees = degrees;
        return this;
    }

    @Schema(name="Used to specify the clockwise rotation in degrees. The rotation is always in 90-degree increments (0, 90, 180, 270, 360). Deviating values will always be rounded down to the next lower increment (e.g.: 32 degrees will become 0 degrees and 101 degrees will become 90 degrees). Once the rotation is completed, the new value will be normalized to a range of 0 to 359 degrees. If the page being rotated has an impermissible value (e.g. 112 degrees), this value will be adjusted before the rotation operation as well (112 degrees will become 90 degrees).")
    @JsonProperty(value="degrees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDegrees() {
        return this.degrees;
    }

    @JsonProperty(value="degrees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDegrees(Integer degrees) {
        this.degrees = degrees;
    }

    public OperationToolboxRotateRotate orientationDetectMode(OrientationDetectModeEnum orientationDetectMode) {
        this.orientationDetectMode = orientationDetectMode;
        return this;
    }

    @Schema(name="Selects which criteria to use to determine the orientation (portrait/landscape) of pages (see also \"pageOrientation\"):  *   value = Based solely on the page rotation value entered in the PDF. *   dimensions = Based on the ratio of the page dimensions to each other.")
    @JsonProperty(value="orientationDetectMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OrientationDetectModeEnum getOrientationDetectMode() {
        return this.orientationDetectMode;
    }

    @JsonProperty(value="orientationDetectMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrientationDetectMode(OrientationDetectModeEnum orientationDetectMode) {
        this.orientationDetectMode = orientationDetectMode;
    }

    public OperationToolboxRotateRotate pageGroup(PageGroupEnum pageGroup) {
        this.pageGroup = pageGroup;
        return this;
    }

    @Schema(name="Used to select pages based on their page number within the specified page range:  *   all = All pages *   even = All pages with an even page number *   odd = All pages with an odd page number")
    @JsonProperty(value="pageGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PageGroupEnum getPageGroup() {
        return this.pageGroup;
    }

    @JsonProperty(value="pageGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageGroup(PageGroupEnum pageGroup) {
        this.pageGroup = pageGroup;
    }

    public OperationToolboxRotateRotate pageOrientation(PageOrientationEnum pageOrientation) {
        this.pageOrientation = pageOrientation;
        return this;
    }

    @Schema(name="Used to select pages based on their orientation within the specified page range:  *   any = All pages *   portrait = All pages in portrait format *   landscape = All pages in landscape format")
    @JsonProperty(value="pageOrientation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PageOrientationEnum getPageOrientation() {
        return this.pageOrientation;
    }

    @JsonProperty(value="pageOrientation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageOrientation(PageOrientationEnum pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    public OperationToolboxRotateRotate pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Defines which page(s) should be rotated. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). To specify \"all pages,\" use an asterisk (\"\\*\").")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationToolboxRotateRotate operationToolboxRotateRotate = (OperationToolboxRotateRotate)o;
        return Objects.equals(this.degrees, operationToolboxRotateRotate.degrees) && Objects.equals((Object)this.orientationDetectMode, (Object)operationToolboxRotateRotate.orientationDetectMode) && Objects.equals((Object)this.pageGroup, (Object)operationToolboxRotateRotate.pageGroup) && Objects.equals((Object)this.pageOrientation, (Object)operationToolboxRotateRotate.pageOrientation) && Objects.equals(this.pages, operationToolboxRotateRotate.pages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.degrees, this.orientationDetectMode, this.pageGroup, this.pageOrientation, this.pages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationToolboxRotateRotate {\n");
        sb.append("    degrees: ").append(this.toIndentedString(this.degrees)).append("\n");
        sb.append("    orientationDetectMode: ").append(this.toIndentedString((Object)this.orientationDetectMode)).append("\n");
        sb.append("    pageGroup: ").append(this.toIndentedString((Object)this.pageGroup)).append("\n");
        sb.append("    pageOrientation: ").append(this.toIndentedString((Object)this.pageOrientation)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PageOrientationEnum {
        ANY(String.valueOf("any")),
        PORTRAIT(String.valueOf("portrait")),
        LANDSCAPE(String.valueOf("landscape"));

        private String value;

        private PageOrientationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PageOrientationEnum fromValue(String value) {
            for (PageOrientationEnum b : PageOrientationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PageGroupEnum {
        ALL(String.valueOf("all")),
        EVEN(String.valueOf("even")),
        ODD(String.valueOf("odd"));

        private String value;

        private PageGroupEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PageGroupEnum fromValue(String value) {
            for (PageGroupEnum b : PageGroupEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OrientationDetectModeEnum {
        VALUE(String.valueOf("value")),
        DIMENSIONS(String.valueOf("dimensions"));

        private String value;

        private OrientationDetectModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrientationDetectModeEnum fromValue(String value) {
            for (OrientationDetectModeEnum b : OrientationDetectModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

