/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="If you use a JPEG \"image type element,\" the file size can be automatically optimized. The corresponding optimization routine will attempt to limit the file to a max. size by gradually reducing the JPEG quality until the image is smaller than a specific size. If the \"sizeOptimization\" block is present, the image will be optimized. If it is not present, the image will not be optimized further after being exported.  **Important:** Please note that optimization can make the graphic export operation significantly slower. In addition to this, make sure to use values for the \"dpi\", \"height\", and \"width\" parameters that ensure that the size you want can actually be reached with compression.")
@JsonPropertyOrder(value={"maxRetries", "maxSize", "stepSize"})
@JsonTypeName(value="Operation_SizeOptimization")
public class OperationSizeOptimization {
    public static final String JSON_PROPERTY_MAX_RETRIES = "maxRetries";
    private Integer maxRetries = 5;
    public static final String JSON_PROPERTY_MAX_SIZE = "maxSize";
    private Integer maxSize = 100000;
    public static final String JSON_PROPERTY_STEP_SIZE = "stepSize";
    private Integer stepSize = 10;

    public OperationSizeOptimization maxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @Schema(name="Used to specify the number of runs that should be used for optimization. If the target size cannot be reached after the specified number of runs, the operation will be cancelled and an error code will be returned.")
    @JsonProperty(value="maxRetries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @JsonProperty(value="maxRetries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public OperationSizeOptimization maxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Schema(name="Used to define the maximum size of the JPEG file (file size), in bytes, that should be reached. The optimization routine will be successfully completed if the file reaches or falls below the specified file size. Make sure to use a value > 0; otherwise, an error will be thrown.")
    @JsonProperty(value="maxSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxSize() {
        return this.maxSize;
    }

    @JsonProperty(value="maxSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public OperationSizeOptimization stepSize(Integer stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    @Schema(name="Used to define the increment by which the JPEG quality (jpegQuality) should be reduced every run in order to reach the desired file size. If the values for maxRetries and stepSize result in an illegal JPEG quality value being reached, the operation will be cancelled and an error code will be returned.")
    @JsonProperty(value="stepSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getStepSize() {
        return this.stepSize;
    }

    @JsonProperty(value="stepSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStepSize(Integer stepSize) {
        this.stepSize = stepSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSizeOptimization operationSizeOptimization = (OperationSizeOptimization)o;
        return Objects.equals(this.maxRetries, operationSizeOptimization.maxRetries) && Objects.equals(this.maxSize, operationSizeOptimization.maxSize) && Objects.equals(this.stepSize, operationSizeOptimization.stepSize);
    }

    public int hashCode() {
        return Objects.hash(this.maxRetries, this.maxSize, this.stepSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSizeOptimization {\n");
        sb.append("    maxRetries: ").append(this.toIndentedString(this.maxRetries)).append("\n");
        sb.append("    maxSize: ").append(this.toIndentedString(this.maxSize)).append("\n");
        sb.append("    stepSize: ").append(this.toIndentedString(this.stepSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

