/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationQrSwissPaymentContent;
import net.webpdf.wsclient.openapi.OperationQrSwissPaymentPdf;
import net.webpdf.wsclient.openapi.OperationRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="A swiss QR payment barcode.")
@JsonPropertyOrder(value={"content", "dpi", "format", "language", "pdf", "position", "separator"})
@JsonTypeName(value="Operation_QrSwissPaymentBarcode")
public class OperationQrSwissPaymentBarcode {
    public static final String JSON_PROPERTY_CONTENT = "content";
    private OperationQrSwissPaymentContent content;
    public static final String JSON_PROPERTY_DPI = "dpi";
    private Integer dpi = 200;
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format = FormatEnum.CODE_ONLY;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private LanguageEnum language = LanguageEnum.DE;
    public static final String JSON_PROPERTY_PDF = "pdf";
    private OperationQrSwissPaymentPdf pdf;
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationRectangle position;
    public static final String JSON_PROPERTY_SEPARATOR = "separator";
    private SeparatorEnum separator = SeparatorEnum.DASHED_LINE_WITH_SCISSORS;

    public OperationQrSwissPaymentBarcode content(OperationQrSwissPaymentContent content) {
        this.content = content;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationQrSwissPaymentContent getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContent(OperationQrSwissPaymentContent content) {
        this.content = content;
    }

    public OperationQrSwissPaymentBarcode dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(name="Used to select the resolution of the barcode.")
    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDpi() {
        return this.dpi;
    }

    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public OperationQrSwissPaymentBarcode format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Schema(name="Used to select the parts, that shall be included in the barcode.  *   codeOnly = Only the barcode itself shall be shown. *   billOnly = The barcode and the payment summary shall be shown. *   billPortraitSheet = The dimensions of the barcode and the payment summary shall be optimized for placement in the lower left corner of a page in DIN-A4 format. *   billExtraSpace = The same as \"billPortraitSheet\", but with extra spacings.")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public OperationQrSwissPaymentBarcode language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @Schema(name="Selects the language of the barcode's payment summary.  *   de = german *   fr = french *   it = italian *   en = english")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public LanguageEnum getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public OperationQrSwissPaymentBarcode pdf(OperationQrSwissPaymentPdf pdf) {
        this.pdf = pdf;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="pdf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationQrSwissPaymentPdf getPdf() {
        return this.pdf;
    }

    @JsonProperty(value="pdf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPdf(OperationQrSwissPaymentPdf pdf) {
        this.pdf = pdf;
    }

    public OperationQrSwissPaymentBarcode position(OperationRectangle position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationRectangle getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationRectangle position) {
        this.position = position;
    }

    public OperationQrSwissPaymentBarcode separator(SeparatorEnum separator) {
        this.separator = separator;
        return this;
    }

    @Schema(name="The border style for separators in between the different parts of the barcode.  *   none = No separator shall be used. *   solidLine = A solid separator line. *   solidLineWithScissors = A solid separator line with a scissor icon. *   dashedLine = A dashed separator line. *   dashedLineWithScissors = A dashed separator line with a scissor icon. *   dottedLine = A dotted separator line. *   dottedLineWithScissors = A dotted separator line with a scissor icon.")
    @JsonProperty(value="separator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SeparatorEnum getSeparator() {
        return this.separator;
    }

    @JsonProperty(value="separator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSeparator(SeparatorEnum separator) {
        this.separator = separator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationQrSwissPaymentBarcode operationQrSwissPaymentBarcode = (OperationQrSwissPaymentBarcode)o;
        return Objects.equals(this.content, operationQrSwissPaymentBarcode.content) && Objects.equals(this.dpi, operationQrSwissPaymentBarcode.dpi) && Objects.equals((Object)this.format, (Object)operationQrSwissPaymentBarcode.format) && Objects.equals((Object)this.language, (Object)operationQrSwissPaymentBarcode.language) && Objects.equals(this.pdf, operationQrSwissPaymentBarcode.pdf) && Objects.equals(this.position, operationQrSwissPaymentBarcode.position) && Objects.equals((Object)this.separator, (Object)operationQrSwissPaymentBarcode.separator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.dpi, this.format, this.language, this.pdf, this.position, this.separator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationQrSwissPaymentBarcode {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    pdf: ").append(this.toIndentedString(this.pdf)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    separator: ").append(this.toIndentedString((Object)this.separator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SeparatorEnum {
        NONE(String.valueOf("none")),
        SOLID_LINE(String.valueOf("solidLine")),
        SOLID_LINE_WITH_SCISSORS(String.valueOf("solidLineWithScissors")),
        DASHED_LINE(String.valueOf("dashedLine")),
        DASHED_LINE_WITH_SCISSORS(String.valueOf("dashedLineWithScissors")),
        DOTTED_LINE(String.valueOf("dottedLine")),
        DOTTED_LINE_WITH_SCISSORS(String.valueOf("dottedLineWithScissors"));

        private String value;

        private SeparatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SeparatorEnum fromValue(String value) {
            for (SeparatorEnum b : SeparatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LanguageEnum {
        DE(String.valueOf("de")),
        FR(String.valueOf("fr")),
        IT(String.valueOf("it")),
        EN(String.valueOf("en"));

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LanguageEnum fromValue(String value) {
            for (LanguageEnum b : LanguageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FormatEnum {
        CODE_ONLY(String.valueOf("codeOnly")),
        BILL_ONLY(String.valueOf("billOnly")),
        BILL_PORTRAIT_SHEET(String.valueOf("billPortraitSheet")),
        BILL_EXTRA_SPACE(String.valueOf("billExtraSpace"));

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

