/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to select a rectangle and define a padding for it's contents.")
@JsonPropertyOrder(value={"bottom", "coordinates", "height", "left", "metrics", "right", "top", "width"})
@JsonTypeName(value="Operation_PaddedRectangle")
public class OperationPaddedRectangle {
    public static final String JSON_PROPERTY_BOTTOM = "bottom";
    private Integer bottom = 0;
    public static final String JSON_PROPERTY_COORDINATES = "coordinates";
    private CoordinatesEnum coordinates = CoordinatesEnum.USER;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Float height = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_LEFT = "left";
    private Integer left = 0;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private MetricsEnum metrics = MetricsEnum.MM;
    public static final String JSON_PROPERTY_RIGHT = "right";
    private Integer right = 0;
    public static final String JSON_PROPERTY_TOP = "top";
    private Integer top = 0;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Float width = Float.valueOf(0.0f);

    public OperationPaddedRectangle bottom(Integer bottom) {
        this.bottom = bottom;
        return this;
    }

    @Schema(name="The bottom padding value.")
    @JsonProperty(value="bottom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getBottom() {
        return this.bottom;
    }

    @JsonProperty(value="bottom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBottom(Integer bottom) {
        this.bottom = bottom;
    }

    public OperationPaddedRectangle coordinates(CoordinatesEnum coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @Schema(name="Used to define the coordinate system and, accordingly, the origin for the position arguments.  *   user = User coordinate system (origin at top left) *   pdf = PDF coordinate system (origin at bottom left)")
    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public CoordinatesEnum getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoordinates(CoordinatesEnum coordinates) {
        this.coordinates = coordinates;
    }

    public OperationPaddedRectangle height(Float height) {
        this.height = height;
        return this;
    }

    @Schema(name="The height dimension.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Float height) {
        this.height = height;
    }

    public OperationPaddedRectangle left(Integer left) {
        this.left = left;
        return this;
    }

    @Schema(name="The left padding value.")
    @JsonProperty(value="left")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getLeft() {
        return this.left;
    }

    @JsonProperty(value="left")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLeft(Integer left) {
        this.left = left;
    }

    public OperationPaddedRectangle metrics(MetricsEnum metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(name="Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetricsEnum getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(MetricsEnum metrics) {
        this.metrics = metrics;
    }

    public OperationPaddedRectangle right(Integer right) {
        this.right = right;
        return this;
    }

    @Schema(name="The right padding value.")
    @JsonProperty(value="right")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRight() {
        return this.right;
    }

    @JsonProperty(value="right")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRight(Integer right) {
        this.right = right;
    }

    public OperationPaddedRectangle top(Integer top) {
        this.top = top;
        return this;
    }

    @Schema(name="The top padding value.")
    @JsonProperty(value="top")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getTop() {
        return this.top;
    }

    @JsonProperty(value="top")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTop(Integer top) {
        this.top = top;
    }

    public OperationPaddedRectangle width(Float width) {
        this.width = width;
        return this;
    }

    @Schema(name="The width dimension.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Float width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPaddedRectangle operationPaddedRectangle = (OperationPaddedRectangle)o;
        return Objects.equals(this.bottom, operationPaddedRectangle.bottom) && Objects.equals((Object)this.coordinates, (Object)operationPaddedRectangle.coordinates) && Objects.equals(this.height, operationPaddedRectangle.height) && Objects.equals(this.left, operationPaddedRectangle.left) && Objects.equals((Object)this.metrics, (Object)operationPaddedRectangle.metrics) && Objects.equals(this.right, operationPaddedRectangle.right) && Objects.equals(this.top, operationPaddedRectangle.top) && Objects.equals(this.width, operationPaddedRectangle.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bottom, this.coordinates, this.height, this.left, this.metrics, this.right, this.top, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPaddedRectangle {\n");
        sb.append("    bottom: ").append(this.toIndentedString(this.bottom)).append("\n");
        sb.append("    coordinates: ").append(this.toIndentedString((Object)this.coordinates)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString((Object)this.metrics)).append("\n");
        sb.append("    right: ").append(this.toIndentedString(this.right)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricsEnum {
        PT(String.valueOf("pt")),
        PC(String.valueOf("pc")),
        PX(String.valueOf("px")),
        MM(String.valueOf("mm")),
        IN(String.valueOf("in"));

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CoordinatesEnum {
        PDF(String.valueOf("pdf")),
        USER(String.valueOf("user"));

        private String value;

        private CoordinatesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CoordinatesEnum fromValue(String value) {
            for (CoordinatesEnum b : CoordinatesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

