/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to specify the font and formatting for the header and footer.")
@JsonPropertyOrder(value={"color", "name", "size", "underline"})
@JsonTypeName(value="Operation_OptionsFont")
public class OperationOptionsFont {
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#000000";
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size = 10;
    public static final String JSON_PROPERTY_UNDERLINE = "underline";
    private Boolean underline = false;

    public OperationOptionsFont color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="Used to set the colour for the text output. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationOptionsFont name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the font that should be used for the text output. If a font is not specified, \"Helvetica\" will be used.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationOptionsFont size(Integer size) {
        this.size = size;
        return this;
    }

    @Schema(name="Used to set the text size for the text output.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public OperationOptionsFont underline(Boolean underline) {
        this.underline = underline;
        return this;
    }

    @Schema(name="If true, the text in the header and footer will be underlined.")
    @JsonProperty(value="underline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUnderline() {
        return this.underline;
    }

    @JsonProperty(value="underline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationOptionsFont operationOptionsFont = (OperationOptionsFont)o;
        return Objects.equals(this.color, operationOptionsFont.color) && Objects.equals(this.name, operationOptionsFont.name) && Objects.equals(this.size, operationOptionsFont.size) && Objects.equals(this.underline, operationOptionsFont.underline);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.name, this.size, this.underline);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationOptionsFont {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    underline: ").append(this.toIndentedString(this.underline)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

