/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationFileSpecification;
import net.webpdf.wsclient.openapi.OperationLaunchParameter;
import org.jetbrains.annotations.Nullable;

@Schema(description="The launchApplication element will open another application or document when activated. The \"applicationPath\" subelement is required. \"launchParameters\" is optional.")
@JsonPropertyOrder(value={"applicationPath", "launchParameters", "newWindow"})
@JsonTypeName(value="Operation_LaunchApplicationAction_launchApplication")
public class OperationLaunchApplicationActionLaunchApplication {
    public static final String JSON_PROPERTY_APPLICATION_PATH = "applicationPath";
    private OperationFileSpecification applicationPath;
    public static final String JSON_PROPERTY_LAUNCH_PARAMETERS = "launchParameters";
    private OperationLaunchParameter launchParameters;
    public static final String JSON_PROPERTY_NEW_WINDOW = "newWindow";
    private NewWindowEnum newWindow = NewWindowEnum.USER_PREFERENCES;

    public OperationLaunchApplicationActionLaunchApplication applicationPath(OperationFileSpecification applicationPath) {
        this.applicationPath = applicationPath;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="applicationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationFileSpecification getApplicationPath() {
        return this.applicationPath;
    }

    @JsonProperty(value="applicationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationPath(OperationFileSpecification applicationPath) {
        this.applicationPath = applicationPath;
    }

    public OperationLaunchApplicationActionLaunchApplication launchParameters(OperationLaunchParameter launchParameters) {
        this.launchParameters = launchParameters;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="launchParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationLaunchParameter getLaunchParameters() {
        return this.launchParameters;
    }

    @JsonProperty(value="launchParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLaunchParameters(OperationLaunchParameter launchParameters) {
        this.launchParameters = launchParameters;
    }

    public OperationLaunchApplicationActionLaunchApplication newWindow(NewWindowEnum newWindow) {
        this.newWindow = newWindow;
        return this;
    }

    @Schema(name="Used to select the window in which the application / document should be opened.  *   userPreference = Uses the variant that is normal in the reader application or that has been configured by the user. *   newWindow = Forces the application or document to be opened in a new window. *   sameWindow = Attempts (if possible) to open the document in the current reader application window.")
    @JsonProperty(value="newWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public NewWindowEnum getNewWindow() {
        return this.newWindow;
    }

    @JsonProperty(value="newWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNewWindow(NewWindowEnum newWindow) {
        this.newWindow = newWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationLaunchApplicationActionLaunchApplication operationLaunchApplicationActionLaunchApplication = (OperationLaunchApplicationActionLaunchApplication)o;
        return Objects.equals(this.applicationPath, operationLaunchApplicationActionLaunchApplication.applicationPath) && Objects.equals(this.launchParameters, operationLaunchApplicationActionLaunchApplication.launchParameters) && Objects.equals((Object)this.newWindow, (Object)operationLaunchApplicationActionLaunchApplication.newWindow);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationPath, this.launchParameters, this.newWindow});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationLaunchApplicationActionLaunchApplication {\n");
        sb.append("    applicationPath: ").append(this.toIndentedString(this.applicationPath)).append("\n");
        sb.append("    launchParameters: ").append(this.toIndentedString(this.launchParameters)).append("\n");
        sb.append("    newWindow: ").append(this.toIndentedString((Object)this.newWindow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NewWindowEnum {
        USER_PREFERENCES(String.valueOf("userPreferences")),
        NEW_WINDOW(String.valueOf("newWindow")),
        SAME_WINDOW(String.valueOf("sameWindow"));

        private String value;

        private NewWindowEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NewWindowEnum fromValue(String value) {
            for (NewWindowEnum b : NewWindowEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

