/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationHttpSettingsHeader;
import net.webpdf.wsclient.openapi.OperationHttpSettingsSSL;
import net.webpdf.wsclient.openapi.OperationHttpSettingsTimeout;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the options for all external HTTP requests made by the server during the execution of the web service operation.")
@JsonPropertyOrder(value={"followRedirect", "headers", "ssl", "timeout", "userAgent"})
@JsonTypeName(value="Operation_HttpSettings")
public class OperationHttpSettings {
    public static final String JSON_PROPERTY_FOLLOW_REDIRECT = "followRedirect";
    private Boolean followRedirect = true;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private OperationHttpSettingsHeader headers;
    public static final String JSON_PROPERTY_SSL = "ssl";
    private OperationHttpSettingsSSL ssl;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    private OperationHttpSettingsTimeout timeout;
    public static final String JSON_PROPERTY_USER_AGENT = "userAgent";
    private String userAgent = "";

    public OperationHttpSettings followRedirect(Boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="followRedirect")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFollowRedirect() {
        return this.followRedirect;
    }

    @JsonProperty(value="followRedirect")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowRedirect(Boolean followRedirect) {
        this.followRedirect = followRedirect;
    }

    public OperationHttpSettings headers(OperationHttpSettingsHeader headers) {
        this.headers = headers;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationHttpSettingsHeader getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaders(OperationHttpSettingsHeader headers) {
        this.headers = headers;
    }

    public OperationHttpSettings ssl(OperationHttpSettingsSSL ssl) {
        this.ssl = ssl;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="ssl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationHttpSettingsSSL getSsl() {
        return this.ssl;
    }

    @JsonProperty(value="ssl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSsl(OperationHttpSettingsSSL ssl) {
        this.ssl = ssl;
    }

    public OperationHttpSettings timeout(OperationHttpSettingsTimeout timeout) {
        this.timeout = timeout;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationHttpSettingsTimeout getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeout(OperationHttpSettingsTimeout timeout) {
        this.timeout = timeout;
    }

    public OperationHttpSettings userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="userAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty(value="userAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationHttpSettings operationHttpSettings = (OperationHttpSettings)o;
        return Objects.equals(this.followRedirect, operationHttpSettings.followRedirect) && Objects.equals(this.headers, operationHttpSettings.headers) && Objects.equals(this.ssl, operationHttpSettings.ssl) && Objects.equals(this.timeout, operationHttpSettings.timeout) && Objects.equals(this.userAgent, operationHttpSettings.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.followRedirect, this.headers, this.ssl, this.timeout, this.userAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationHttpSettings {\n");
        sb.append("    followRedirect: ").append(this.toIndentedString(this.followRedirect)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    ssl: ").append(this.toIndentedString(this.ssl)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

