/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The fitWidth element is used to specify a location within the document. It will jump to a page in the document and set a zoom factor that will ensure that the entire page width is displayed.")
@JsonPropertyOrder(value={"metrics", "page", "topOffset"})
@JsonTypeName(value="Operation_FitWidthDestination_fitWidth")
public class OperationFitWidthDestinationFitWidth {
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private MetricsEnum metrics = MetricsEnum.PX;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_TOP_OFFSET = "topOffset";
    private Integer topOffset = 0;

    public OperationFitWidthDestinationFitWidth metrics(MetricsEnum metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(name="Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetricsEnum getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(MetricsEnum metrics) {
        this.metrics = metrics;
    }

    public OperationFitWidthDestinationFitWidth page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The document page to which the jump will be.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationFitWidthDestinationFitWidth topOffset(Integer topOffset) {
        this.topOffset = topOffset;
        return this;
    }

    @Schema(name="The area's offset from the top page margin.")
    @JsonProperty(value="topOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getTopOffset() {
        return this.topOffset;
    }

    @JsonProperty(value="topOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTopOffset(Integer topOffset) {
        this.topOffset = topOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFitWidthDestinationFitWidth operationFitWidthDestinationFitWidth = (OperationFitWidthDestinationFitWidth)o;
        return Objects.equals((Object)this.metrics, (Object)operationFitWidthDestinationFitWidth.metrics) && Objects.equals(this.page, operationFitWidthDestinationFitWidth.page) && Objects.equals(this.topOffset, operationFitWidthDestinationFitWidth.topOffset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metrics, this.page, this.topOffset});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationFitWidthDestinationFitWidth {\n");
        sb.append("    metrics: ").append(this.toIndentedString((Object)this.metrics)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    topOffset: ").append(this.toIndentedString(this.topOffset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricsEnum {
        PT(String.valueOf("pt")),
        PC(String.valueOf("pc")),
        PX(String.valueOf("px")),
        MM(String.valueOf("mm")),
        IN(String.valueOf("in"));

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

