/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to specify the location and additional parameters for running an application or opening a document.")
@JsonPropertyOrder(value={"description", "resourceURL", "volatileFile"})
@JsonTypeName(value="Operation_FileSpecification")
public class OperationFileSpecification {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description = "";
    public static final String JSON_PROPERTY_RESOURCE_U_R_L = "resourceURL";
    private String resourceURL = "";
    public static final String JSON_PROPERTY_VOLATILE_FILE = "volatileFile";
    private Boolean volatileFile = false;

    public OperationFileSpecification description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="A description of the application that should be opened.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public OperationFileSpecification resourceURL(String resourceURL) {
        this.resourceURL = resourceURL;
        return this;
    }

    @Schema(name="The path or URL for the application / document. Use forward slashes as path separators. It is potentially possible to use platform-specific characters, but this is not recommended. If you do end up using platform-specific characters anyway, they must be preceded by a backslash (\u2018\\\\').")
    @JsonProperty(value="resourceURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getResourceURL() {
        return this.resourceURL;
    }

    @JsonProperty(value="resourceURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceURL(String resourceURL) {
        this.resourceURL = resourceURL;
    }

    public OperationFileSpecification volatileFile(Boolean volatileFile) {
        this.volatileFile = volatileFile;
        return this;
    }

    @Schema(name="This value should be set to true if the selected document will be subject to changes continuously and the reader application should be forced to continuously reload the document instead of caching it.")
    @JsonProperty(value="volatileFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getVolatileFile() {
        return this.volatileFile;
    }

    @JsonProperty(value="volatileFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVolatileFile(Boolean volatileFile) {
        this.volatileFile = volatileFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFileSpecification operationFileSpecification = (OperationFileSpecification)o;
        return Objects.equals(this.description, operationFileSpecification.description) && Objects.equals(this.resourceURL, operationFileSpecification.resourceURL) && Objects.equals(this.volatileFile, operationFileSpecification.volatileFile);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.resourceURL, this.volatileFile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationFileSpecification {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    resourceURL: ").append(this.toIndentedString(this.resourceURL)).append("\n");
        sb.append("    volatileFile: ").append(this.toIndentedString(this.volatileFile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

