/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Extract all the words from the PDF document, with page and position information.  Generates an ASCII text, XML, or JSON file that will be returned as a result when the web service is called. For each found word, the file will contain the page number and the X-axis and Y-axis coordinates of the word. When the TEXT output format is selected, only the word's text will be output, separated with line breaks.")
@JsonPropertyOrder(value={"delimitAfterPunctuation", "extendedSequenceCharacters", "fileFormat", "pages", "removePunctuation"})
@JsonTypeName(value="Operation_ExtractionWords")
public class OperationExtractionWords {
    public static final String JSON_PROPERTY_DELIMIT_AFTER_PUNCTUATION = "delimitAfterPunctuation";
    private Boolean delimitAfterPunctuation = true;
    public static final String JSON_PROPERTY_EXTENDED_SEQUENCE_CHARACTERS = "extendedSequenceCharacters";
    private Boolean extendedSequenceCharacters = false;
    public static final String JSON_PROPERTY_FILE_FORMAT = "fileFormat";
    private FileFormatEnum fileFormat = FileFormatEnum.XML;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";
    public static final String JSON_PROPERTY_REMOVE_PUNCTUATION = "removePunctuation";
    private Boolean removePunctuation = false;

    public OperationExtractionWords delimitAfterPunctuation(Boolean delimitAfterPunctuation) {
        this.delimitAfterPunctuation = delimitAfterPunctuation;
        return this;
    }

    @Schema(name="If this attribute is set to true, a new word will be started after each punctuation mark.")
    @JsonProperty(value="delimitAfterPunctuation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getDelimitAfterPunctuation() {
        return this.delimitAfterPunctuation;
    }

    @JsonProperty(value="delimitAfterPunctuation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDelimitAfterPunctuation(Boolean delimitAfterPunctuation) {
        this.delimitAfterPunctuation = delimitAfterPunctuation;
    }

    public OperationExtractionWords extendedSequenceCharacters(Boolean extendedSequenceCharacters) {
        this.extendedSequenceCharacters = extendedSequenceCharacters;
        return this;
    }

    @Schema(name="This attribute specifies whether quotation marks and apostrophes should be handled the same way as brackets (such as parentheses and square brackets), i.e., whether they should be placed before the word they enclose.")
    @JsonProperty(value="extendedSequenceCharacters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getExtendedSequenceCharacters() {
        return this.extendedSequenceCharacters;
    }

    @JsonProperty(value="extendedSequenceCharacters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtendedSequenceCharacters(Boolean extendedSequenceCharacters) {
        this.extendedSequenceCharacters = extendedSequenceCharacters;
    }

    public OperationExtractionWords fileFormat(FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Schema(name="Used to define the output format for the PDF document text contents being extracted.  *   text = Text document *   xml = XML document *   json = JSON data structure")
    @JsonProperty(value="fileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FileFormatEnum getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty(value="fileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileFormat(FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
    }

    public OperationExtractionWords pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Used to define which page(s) should be used for the extraction mode. The page number can be either an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). A blank value or \"\\*\" selects all pages of the PDF document.")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationExtractionWords removePunctuation(Boolean removePunctuation) {
        this.removePunctuation = removePunctuation;
        return this;
    }

    @Schema(name="Used to specify whether punctuation marks should be included in the export or whether they should be explicitly removed.")
    @JsonProperty(value="removePunctuation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRemovePunctuation() {
        return this.removePunctuation;
    }

    @JsonProperty(value="removePunctuation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemovePunctuation(Boolean removePunctuation) {
        this.removePunctuation = removePunctuation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationExtractionWords operationExtractionWords = (OperationExtractionWords)o;
        return Objects.equals(this.delimitAfterPunctuation, operationExtractionWords.delimitAfterPunctuation) && Objects.equals(this.extendedSequenceCharacters, operationExtractionWords.extendedSequenceCharacters) && Objects.equals((Object)this.fileFormat, (Object)operationExtractionWords.fileFormat) && Objects.equals(this.pages, operationExtractionWords.pages) && Objects.equals(this.removePunctuation, operationExtractionWords.removePunctuation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.delimitAfterPunctuation, this.extendedSequenceCharacters, this.fileFormat, this.pages, this.removePunctuation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationExtractionWords {\n");
        sb.append("    delimitAfterPunctuation: ").append(this.toIndentedString(this.delimitAfterPunctuation)).append("\n");
        sb.append("    extendedSequenceCharacters: ").append(this.toIndentedString(this.extendedSequenceCharacters)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString((Object)this.fileFormat)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    removePunctuation: ").append(this.toIndentedString(this.removePunctuation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FileFormatEnum {
        TEXT(String.valueOf("text")),
        XML(String.valueOf("xml")),
        JSON(String.valueOf("json")),
        ZIP(String.valueOf("zip"));

        private String value;

        private FileFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileFormatEnum fromValue(String value) {
            for (FileFormatEnum b : FileFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

