/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationSelectionAttachment;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to extract one or more attachments from the document. If more than one file is defined with selection, the result is returned in the form of a ZIP document.")
@JsonPropertyOrder(value={"folderNameTemplate", "selection", "singleFileAsZip"})
@JsonTypeName(value="Operation_ExtractToolboxAttachment")
public class OperationExtractToolboxAttachment {
    public static final String JSON_PROPERTY_FOLDER_NAME_TEMPLATE = "folderNameTemplate";
    private String folderNameTemplate = "page[%d]";
    public static final String JSON_PROPERTY_SELECTION = "selection";
    private List<OperationSelectionAttachment> selection = null;
    public static final String JSON_PROPERTY_SINGLE_FILE_AS_ZIP = "singleFileAsZip";
    private Boolean singleFileAsZip = true;

    public OperationExtractToolboxAttachment folderNameTemplate(String folderNameTemplate) {
        this.folderNameTemplate = folderNameTemplate;
        return this;
    }

    @Schema(name="Used to set the template for the page folders in the returned ZIP file. \"page\\[%d\\]\", for example, would result in a folder called \"page1\" for page 1, etc.")
    @JsonProperty(value="folderNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFolderNameTemplate() {
        return this.folderNameTemplate;
    }

    @JsonProperty(value="folderNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFolderNameTemplate(String folderNameTemplate) {
        this.folderNameTemplate = folderNameTemplate;
    }

    public OperationExtractToolboxAttachment selection(List<OperationSelectionAttachment> selection) {
        this.selection = selection;
        return this;
    }

    public OperationExtractToolboxAttachment addSelectionItem(OperationSelectionAttachment selectionItem) {
        if (this.selection == null) {
            this.selection = new ArrayList<OperationSelectionAttachment>();
        }
        this.selection.add(selectionItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="selection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationSelectionAttachment> getSelection() {
        return this.selection;
    }

    @JsonProperty(value="selection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelection(List<OperationSelectionAttachment> selection) {
        this.selection = selection;
    }

    public OperationExtractToolboxAttachment singleFileAsZip(Boolean singleFileAsZip) {
        this.singleFileAsZip = singleFileAsZip;
        return this;
    }

    @Schema(name="The returned attachments will be combined to a common ZIP file, even if the selection is resulting in a single attachment to be selected. You can change this behaviour by setting this option to \"false\". In that case, this will expect to select a single attachment, that can be returned \"as is\".")
    @JsonProperty(value="singleFileAsZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getSingleFileAsZip() {
        return this.singleFileAsZip;
    }

    @JsonProperty(value="singleFileAsZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSingleFileAsZip(Boolean singleFileAsZip) {
        this.singleFileAsZip = singleFileAsZip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationExtractToolboxAttachment operationExtractToolboxAttachment = (OperationExtractToolboxAttachment)o;
        return Objects.equals(this.folderNameTemplate, operationExtractToolboxAttachment.folderNameTemplate) && Objects.equals(this.selection, operationExtractToolboxAttachment.selection) && Objects.equals(this.singleFileAsZip, operationExtractToolboxAttachment.singleFileAsZip);
    }

    public int hashCode() {
        return Objects.hash(this.folderNameTemplate, this.selection, this.singleFileAsZip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationExtractToolboxAttachment {\n");
        sb.append("    folderNameTemplate: ").append(this.toIndentedString(this.folderNameTemplate)).append("\n");
        sb.append("    selection: ").append(this.toIndentedString(this.selection)).append("\n");
        sb.append("    singleFileAsZip: ").append(this.toIndentedString(this.singleFileAsZip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

