/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPagesBackgroundBaseSettings;
import net.webpdf.wsclient.openapi.OperationPositionBackgroundBaseSettings;
import net.webpdf.wsclient.openapi.OperationVisibilityBackgroundBaseSettings;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines basic configuration settings for generating background layers.")
@JsonPropertyOrder(value={"opacity", "pages", "position", "relativeToPage", "replaceExisting", "rotation", "scale", "visibility"})
@JsonTypeName(value="Operation_BackgroundBaseSettings")
public class OperationBackgroundBaseSettings {
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 100;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private OperationPagesBackgroundBaseSettings pages;
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationPositionBackgroundBaseSettings position;
    public static final String JSON_PROPERTY_RELATIVE_TO_PAGE = "relativeToPage";
    private Boolean relativeToPage = true;
    public static final String JSON_PROPERTY_REPLACE_EXISTING = "replaceExisting";
    private Boolean replaceExisting = false;
    public static final String JSON_PROPERTY_ROTATION = "rotation";
    private Integer rotation = 0;
    public static final String JSON_PROPERTY_SCALE = "scale";
    private Integer scale = 100;
    public static final String JSON_PROPERTY_VISIBILITY = "visibility";
    private OperationVisibilityBackgroundBaseSettings visibility;

    public OperationBackgroundBaseSettings opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="A percentage value that is used to specify the background layer's transparency (100 percent means fully visible).")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public OperationBackgroundBaseSettings pages(OperationPagesBackgroundBaseSettings pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPagesBackgroundBaseSettings getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(OperationPagesBackgroundBaseSettings pages) {
        this.pages = pages;
    }

    public OperationBackgroundBaseSettings position(OperationPositionBackgroundBaseSettings position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPositionBackgroundBaseSettings getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationPositionBackgroundBaseSettings position) {
        this.position = position;
    }

    public OperationBackgroundBaseSettings relativeToPage(Boolean relativeToPage) {
        this.relativeToPage = relativeToPage;
        return this;
    }

    @Schema(name="If true, the background layer will not be scaled relative to its own original size, but rather to the dimensions of the page containing it.")
    @JsonProperty(value="relativeToPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRelativeToPage() {
        return this.relativeToPage;
    }

    @JsonProperty(value="relativeToPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelativeToPage(Boolean relativeToPage) {
        this.relativeToPage = relativeToPage;
    }

    public OperationBackgroundBaseSettings replaceExisting(Boolean replaceExisting) {
        this.replaceExisting = replaceExisting;
        return this;
    }

    @Schema(name="If true, an existing background layer will be automatically deleted and replaced with the new one. If false, an existing background layer will cause the operation to be aborted.")
    @JsonProperty(value="replaceExisting")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getReplaceExisting() {
        return this.replaceExisting;
    }

    @JsonProperty(value="replaceExisting")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReplaceExisting(Boolean replaceExisting) {
        this.replaceExisting = replaceExisting;
    }

    public OperationBackgroundBaseSettings rotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    @Schema(name="A value between 0 and 360 degrees that is used to specify the background layer's rotation.")
    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRotation() {
        return this.rotation;
    }

    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    public OperationBackgroundBaseSettings scale(Integer scale) {
        this.scale = scale;
        return this;
    }

    @Schema(name="A percentage value used to specify the scaling for the background layer. This scaling can either be relative to the background layer's original size or to the dimensions of the page containing it (depends on the \"relativeToPage\" parameter)")
    @JsonProperty(value="scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getScale() {
        return this.scale;
    }

    @JsonProperty(value="scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public OperationBackgroundBaseSettings visibility(OperationVisibilityBackgroundBaseSettings visibility) {
        this.visibility = visibility;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationVisibilityBackgroundBaseSettings getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisibility(OperationVisibilityBackgroundBaseSettings visibility) {
        this.visibility = visibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationBackgroundBaseSettings operationBackgroundBaseSettings = (OperationBackgroundBaseSettings)o;
        return Objects.equals(this.opacity, operationBackgroundBaseSettings.opacity) && Objects.equals(this.pages, operationBackgroundBaseSettings.pages) && Objects.equals(this.position, operationBackgroundBaseSettings.position) && Objects.equals(this.relativeToPage, operationBackgroundBaseSettings.relativeToPage) && Objects.equals(this.replaceExisting, operationBackgroundBaseSettings.replaceExisting) && Objects.equals(this.rotation, operationBackgroundBaseSettings.rotation) && Objects.equals(this.scale, operationBackgroundBaseSettings.scale) && Objects.equals(this.visibility, operationBackgroundBaseSettings.visibility);
    }

    public int hashCode() {
        return Objects.hash(this.opacity, this.pages, this.position, this.relativeToPage, this.replaceExisting, this.rotation, this.scale, this.visibility);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationBackgroundBaseSettings {\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    relativeToPage: ").append(this.toIndentedString(this.relativeToPage)).append("\n");
        sb.append("    replaceExisting: ").append(this.toIndentedString(this.replaceExisting)).append("\n");
        sb.append("    rotation: ").append(this.toIndentedString(this.rotation)).append("\n");
        sb.append("    scale: ").append(this.toIndentedString(this.scale)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

