/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The annotation element can be used to select document annotations that should be modified. The name of the relevant \"annotations\" container will depend on the definition context. The container can contain 0 to n \"annotation\" elements.")
@JsonPropertyOrder(value={"index", "name", "page"})
@JsonTypeName(value="Operation_AnnotationSelection")
public class OperationAnnotationSelection {
    public static final String JSON_PROPERTY_INDEX = "index";
    private Integer index = 0;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;

    public OperationAnnotationSelection index(Integer index) {
        this.index = index;
        return this;
    }

    @Schema(name="The index for the annotation in the page's annotation directory. This value is an alternative to the annotation name and does not have to be set if an annotation name is specified.")
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getIndex() {
        return this.index;
    }

    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndex(Integer index) {
        this.index = index;
    }

    public OperationAnnotationSelection name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="The name of the annotation in the page's annotation directory. This value is an alternative to the annotation index and does not have to be set if an annotation index is specified.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationAnnotationSelection page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The page number of the page where the annotation is found.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationAnnotationSelection operationAnnotationSelection = (OperationAnnotationSelection)o;
        return Objects.equals(this.index, operationAnnotationSelection.index) && Objects.equals(this.name, operationAnnotationSelection.name) && Objects.equals(this.page, operationAnnotationSelection.page);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.name, this.page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationAnnotationSelection {\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

