/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataPassword;
import org.jetbrains.annotations.Nullable;

@Schema(description="An element of this type shall contain information concerning the security settings, manipulation protection and used password of a PDF document.")
@JsonPropertyOrder(value={"canAssemble", "canExtractContent", "canExtractForAccessibility", "canFillInForm", "canModify", "canModifyAnnotations", "canPrint", "canPrintHighRes", "password"})
@JsonTypeName(value="Metadata_Security")
public class MetadataSecurity {
    public static final String JSON_PROPERTY_CAN_ASSEMBLE = "canAssemble";
    private Boolean canAssemble = true;
    public static final String JSON_PROPERTY_CAN_EXTRACT_CONTENT = "canExtractContent";
    private Boolean canExtractContent = true;
    public static final String JSON_PROPERTY_CAN_EXTRACT_FOR_ACCESSIBILITY = "canExtractForAccessibility";
    private Boolean canExtractForAccessibility = true;
    public static final String JSON_PROPERTY_CAN_FILL_IN_FORM = "canFillInForm";
    private Boolean canFillInForm = true;
    public static final String JSON_PROPERTY_CAN_MODIFY = "canModify";
    private Boolean canModify = true;
    public static final String JSON_PROPERTY_CAN_MODIFY_ANNOTATIONS = "canModifyAnnotations";
    private Boolean canModifyAnnotations = true;
    public static final String JSON_PROPERTY_CAN_PRINT = "canPrint";
    private Boolean canPrint = true;
    public static final String JSON_PROPERTY_CAN_PRINT_HIGH_RES = "canPrintHighRes";
    private Boolean canPrintHighRes = true;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private MetadataPassword password;

    public MetadataSecurity canAssemble(Boolean canAssemble) {
        this.canAssemble = canAssemble;
        return this;
    }

    @Schema(name="If \"true,\" the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).")
    @JsonProperty(value="canAssemble")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanAssemble() {
        return this.canAssemble;
    }

    @JsonProperty(value="canAssemble")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanAssemble(Boolean canAssemble) {
        this.canAssemble = canAssemble;
    }

    public MetadataSecurity canExtractContent(Boolean canExtractContent) {
        this.canExtractContent = canExtractContent;
        return this;
    }

    @Schema(name="If \"true,\" content can be extracted (copied) from the document.")
    @JsonProperty(value="canExtractContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanExtractContent() {
        return this.canExtractContent;
    }

    @JsonProperty(value="canExtractContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanExtractContent(Boolean canExtractContent) {
        this.canExtractContent = canExtractContent;
    }

    public MetadataSecurity canExtractForAccessibility(Boolean canExtractForAccessibility) {
        this.canExtractForAccessibility = canExtractForAccessibility;
        return this;
    }

    @Schema(name="If \"true,\" content can be extracted (copied) for accessibility purposes.")
    @JsonProperty(value="canExtractForAccessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanExtractForAccessibility() {
        return this.canExtractForAccessibility;
    }

    @JsonProperty(value="canExtractForAccessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanExtractForAccessibility(Boolean canExtractForAccessibility) {
        this.canExtractForAccessibility = canExtractForAccessibility;
    }

    public MetadataSecurity canFillInForm(Boolean canFillInForm) {
        this.canFillInForm = canFillInForm;
        return this;
    }

    @Schema(name="If \"true,\" form fields can be filled out and the document can be signed.")
    @JsonProperty(value="canFillInForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanFillInForm() {
        return this.canFillInForm;
    }

    @JsonProperty(value="canFillInForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanFillInForm(Boolean canFillInForm) {
        this.canFillInForm = canFillInForm;
    }

    public MetadataSecurity canModify(Boolean canModify) {
        this.canModify = canModify;
        return this;
    }

    @Schema(name="If \"true,\" changes to the document are permitted.")
    @JsonProperty(value="canModify")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanModify() {
        return this.canModify;
    }

    @JsonProperty(value="canModify")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanModify(Boolean canModify) {
        this.canModify = canModify;
    }

    public MetadataSecurity canModifyAnnotations(Boolean canModifyAnnotations) {
        this.canModifyAnnotations = canModifyAnnotations;
        return this;
    }

    @Schema(name="If \"true,\" comments can be added to the document and deleted from the document.")
    @JsonProperty(value="canModifyAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanModifyAnnotations() {
        return this.canModifyAnnotations;
    }

    @JsonProperty(value="canModifyAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanModifyAnnotations(Boolean canModifyAnnotations) {
        this.canModifyAnnotations = canModifyAnnotations;
    }

    public MetadataSecurity canPrint(Boolean canPrint) {
        this.canPrint = canPrint;
        return this;
    }

    @Schema(name="If \"true,\" the document can be printed.")
    @JsonProperty(value="canPrint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanPrint() {
        return this.canPrint;
    }

    @JsonProperty(value="canPrint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanPrint(Boolean canPrint) {
        this.canPrint = canPrint;
    }

    public MetadataSecurity canPrintHighRes(Boolean canPrintHighRes) {
        this.canPrintHighRes = canPrintHighRes;
        return this;
    }

    @Schema(name="If \"true,\" the document can be printed at high resolution levels.")
    @JsonProperty(value="canPrintHighRes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanPrintHighRes() {
        return this.canPrintHighRes;
    }

    @JsonProperty(value="canPrintHighRes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanPrintHighRes(Boolean canPrintHighRes) {
        this.canPrintHighRes = canPrintHighRes;
    }

    public MetadataSecurity password(MetadataPassword password) {
        this.password = password;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataPassword getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(MetadataPassword password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataSecurity metadataSecurity = (MetadataSecurity)o;
        return Objects.equals(this.canAssemble, metadataSecurity.canAssemble) && Objects.equals(this.canExtractContent, metadataSecurity.canExtractContent) && Objects.equals(this.canExtractForAccessibility, metadataSecurity.canExtractForAccessibility) && Objects.equals(this.canFillInForm, metadataSecurity.canFillInForm) && Objects.equals(this.canModify, metadataSecurity.canModify) && Objects.equals(this.canModifyAnnotations, metadataSecurity.canModifyAnnotations) && Objects.equals(this.canPrint, metadataSecurity.canPrint) && Objects.equals(this.canPrintHighRes, metadataSecurity.canPrintHighRes) && Objects.equals(this.password, metadataSecurity.password);
    }

    public int hashCode() {
        return Objects.hash(this.canAssemble, this.canExtractContent, this.canExtractForAccessibility, this.canFillInForm, this.canModify, this.canModifyAnnotations, this.canPrint, this.canPrintHighRes, this.password);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataSecurity {\n");
        sb.append("    canAssemble: ").append(this.toIndentedString(this.canAssemble)).append("\n");
        sb.append("    canExtractContent: ").append(this.toIndentedString(this.canExtractContent)).append("\n");
        sb.append("    canExtractForAccessibility: ").append(this.toIndentedString(this.canExtractForAccessibility)).append("\n");
        sb.append("    canFillInForm: ").append(this.toIndentedString(this.canFillInForm)).append("\n");
        sb.append("    canModify: ").append(this.toIndentedString(this.canModify)).append("\n");
        sb.append("    canModifyAnnotations: ").append(this.toIndentedString(this.canModifyAnnotations)).append("\n");
        sb.append("    canPrint: ").append(this.toIndentedString(this.canPrint)).append("\n");
        sb.append("    canPrintHighRes: ").append(this.toIndentedString(this.canPrintHighRes)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

