/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataDocument;
import org.jetbrains.annotations.Nullable;

@Schema(description="This type is used to describe an attachment, that has been embedded in a PDF file. The attachment itself may have connected document information, in that case the \"document\" element will be set.")
@JsonPropertyOrder(value={"description", "documentType", "folderId", "mimeType", "name", "number", "objectKey", "page", "size"})
@JsonTypeName(value="Metadata_Attachment")
public class MetadataAttachment {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description = "";
    public static final String JSON_PROPERTY_DOCUMENT_TYPE = "documentType";
    private MetadataDocument documentType;
    public static final String JSON_PROPERTY_FOLDER_ID = "folderId";
    private Integer folderId = 0;
    public static final String JSON_PROPERTY_MIME_TYPE = "mimeType";
    private String mimeType = "";
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_NUMBER = "number";
    private Integer number = 0;
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Double size = 0.0;

    public MetadataAttachment description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="The file description of the attachment.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public MetadataAttachment documentType(MetadataDocument documentType) {
        this.documentType = documentType;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="documentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataDocument getDocumentType() {
        return this.documentType;
    }

    @JsonProperty(value="documentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentType(MetadataDocument documentType) {
        this.documentType = documentType;
    }

    public MetadataAttachment folderId(Integer folderId) {
        this.folderId = folderId;
        return this;
    }

    @Schema(name="The numeric ID of the folder containing the attachment. (This is only relevant for PDF Collections/Portfolios - otherwise attachments may not be arranged in a folder tree.)")
    @JsonProperty(value="folderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getFolderId() {
        return this.folderId;
    }

    @JsonProperty(value="folderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFolderId(Integer folderId) {
        this.folderId = folderId;
    }

    public MetadataAttachment mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(name="The attachment's MIME type.")
    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public MetadataAttachment name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="The file name of the attachment.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MetadataAttachment number(Integer number) {
        this.number = number;
        return this;
    }

    @Schema(name="The position number of the attachment in the embedded files of the document.")
    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(Integer number) {
        this.number = number;
    }

    public MetadataAttachment objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the attachment. **Info:** A PDF objects ID consists of two number, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataAttachment page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The page (if any), the attachment is placed on.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public MetadataAttachment size(Double size) {
        this.size = size;
        return this;
    }

    @Schema(name="The byte size of the attachment.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Double getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSize(Double size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataAttachment metadataAttachment = (MetadataAttachment)o;
        return Objects.equals(this.description, metadataAttachment.description) && Objects.equals(this.documentType, metadataAttachment.documentType) && Objects.equals(this.folderId, metadataAttachment.folderId) && Objects.equals(this.mimeType, metadataAttachment.mimeType) && Objects.equals(this.name, metadataAttachment.name) && Objects.equals(this.number, metadataAttachment.number) && Objects.equals(this.objectKey, metadataAttachment.objectKey) && Objects.equals(this.page, metadataAttachment.page) && Objects.equals(this.size, metadataAttachment.size);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.documentType, this.folderId, this.mimeType, this.name, this.number, this.objectKey, this.page, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataAttachment {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString(this.documentType)).append("\n");
        sb.append("    folderId: ").append(this.toIndentedString(this.folderId)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

