/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.KeyStoreOrigin;
import org.jetbrains.annotations.Nullable;

@Schema(description="A user keystore entry")
@JsonPropertyOrder(value={"isKeyStoreAccessible", "keyStoreName", "keyStoreOrigin"})
@JsonTypeName(value="KeyStore_Entry")
public class KeyStoreEntry {
    public static final String JSON_PROPERTY_IS_KEY_STORE_ACCESSIBLE = "isKeyStoreAccessible";
    private Boolean isKeyStoreAccessible = false;
    public static final String JSON_PROPERTY_KEY_STORE_NAME = "keyStoreName";
    private String keyStoreName = "";
    public static final String JSON_PROPERTY_KEY_STORE_ORIGIN = "keyStoreOrigin";
    private KeyStoreOrigin keyStoreOrigin = KeyStoreOrigin.GLOBAL;

    public KeyStoreEntry() {
    }

    @JsonCreator
    public KeyStoreEntry(@JsonProperty(value="isKeyStoreAccessible") Boolean isKeyStoreAccessible, @JsonProperty(value="keyStoreName") String keyStoreName) {
        this();
        this.isKeyStoreAccessible = isKeyStoreAccessible;
        this.keyStoreName = keyStoreName;
    }

    @Schema(name="true = Keystore is accessible and the content is readable")
    @JsonProperty(value="isKeyStoreAccessible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsKeyStoreAccessible() {
        return this.isKeyStoreAccessible;
    }

    @Schema(name="Name of the keystore")
    @JsonProperty(value="keyStoreName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getKeyStoreName() {
        return this.keyStoreName;
    }

    public KeyStoreEntry keyStoreOrigin(KeyStoreOrigin keyStoreOrigin) {
        this.keyStoreOrigin = keyStoreOrigin;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="keyStoreOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public KeyStoreOrigin getKeyStoreOrigin() {
        return this.keyStoreOrigin;
    }

    @JsonProperty(value="keyStoreOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyStoreOrigin(KeyStoreOrigin keyStoreOrigin) {
        this.keyStoreOrigin = keyStoreOrigin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyStoreEntry keyStoreEntry = (KeyStoreEntry)o;
        return Objects.equals(this.isKeyStoreAccessible, keyStoreEntry.isKeyStoreAccessible) && Objects.equals(this.keyStoreName, keyStoreEntry.keyStoreName) && Objects.equals((Object)this.keyStoreOrigin, (Object)keyStoreEntry.keyStoreOrigin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isKeyStoreAccessible, this.keyStoreName, this.keyStoreOrigin});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyStoreEntry {\n");
        sb.append("    isKeyStoreAccessible: ").append(this.toIndentedString(this.isKeyStoreAccessible)).append("\n");
        sb.append("    keyStoreName: ").append(this.toIndentedString(this.keyStoreName)).append("\n");
        sb.append("    keyStoreOrigin: ").append(this.toIndentedString((Object)this.keyStoreOrigin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

