/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.Objects;
import net.webpdf.wsclient.openapi.DocumentMetadataImageOrientation;
import net.webpdf.wsclient.openapi.DocumentMetadataImageResolutionUnit;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines an image entry in the metadata for an image document.")
@JsonPropertyOrder(value={"colorDepth", "height", "isAnimated", "metadata", "orientation", "unit", "width", "xRes", "yRes"})
@JsonTypeName(value="Document_MetadataImageEntry")
public class DocumentMetadataImageEntry {
    public static final String JSON_PROPERTY_COLOR_DEPTH = "colorDepth";
    private Integer colorDepth = 0;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height = 0;
    public static final String JSON_PROPERTY_IS_ANIMATED = "isAnimated";
    private Boolean isAnimated = false;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, Map<String, String>> metadata = null;
    public static final String JSON_PROPERTY_ORIENTATION = "orientation";
    private DocumentMetadataImageOrientation orientation = DocumentMetadataImageOrientation.TOP_LEFT;
    public static final String JSON_PROPERTY_UNIT = "unit";
    private DocumentMetadataImageResolutionUnit unit = DocumentMetadataImageResolutionUnit.INCH;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width = 0;
    public static final String JSON_PROPERTY_X_RES = "xRes";
    private Float xRes = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_Y_RES = "yRes";
    private Float yRes = Float.valueOf(0.0f);

    public DocumentMetadataImageEntry() {
    }

    @JsonCreator
    public DocumentMetadataImageEntry(@JsonProperty(value="colorDepth") Integer colorDepth, @JsonProperty(value="height") Integer height, @JsonProperty(value="isAnimated") Boolean isAnimated, @JsonProperty(value="metadata") Map<String, Map<String, String>> metadata, @JsonProperty(value="width") Integer width, @JsonProperty(value="xRes") Float xRes, @JsonProperty(value="yRes") Float yRes) {
        this();
        this.colorDepth = colorDepth;
        this.height = height;
        this.isAnimated = isAnimated;
        this.metadata = metadata;
        this.width = width;
        this.xRes = xRes;
        this.yRes = yRes;
    }

    @Schema(name="Color depth in bits")
    @JsonProperty(value="colorDepth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getColorDepth() {
        return this.colorDepth;
    }

    @Schema(name="Image height")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getHeight() {
        return this.height;
    }

    @Schema(name="True if it is an animated image")
    @JsonProperty(value="isAnimated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsAnimated() {
        return this.isAnimated;
    }

    @Schema(name="Metadata dictionary of the image file format")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Map<String, Map<String, String>> getMetadata() {
        return this.metadata;
    }

    public DocumentMetadataImageEntry orientation(DocumentMetadataImageOrientation orientation) {
        this.orientation = orientation;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="orientation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DocumentMetadataImageOrientation getOrientation() {
        return this.orientation;
    }

    public DocumentMetadataImageEntry unit(DocumentMetadataImageResolutionUnit unit) {
        this.unit = unit;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="unit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DocumentMetadataImageResolutionUnit getUnit() {
        return this.unit;
    }

    @Schema(name="Image width")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    @Schema(name="Horizontal resolution")
    @JsonProperty(value="xRes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getxRes() {
        return this.xRes;
    }

    @Schema(name="Vertical resolution")
    @JsonProperty(value="yRes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getyRes() {
        return this.yRes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentMetadataImageEntry documentMetadataImageEntry = (DocumentMetadataImageEntry)o;
        return Objects.equals(this.colorDepth, documentMetadataImageEntry.colorDepth) && Objects.equals(this.height, documentMetadataImageEntry.height) && Objects.equals(this.isAnimated, documentMetadataImageEntry.isAnimated) && Objects.equals(this.metadata, documentMetadataImageEntry.metadata) && Objects.equals((Object)this.orientation, (Object)documentMetadataImageEntry.orientation) && Objects.equals((Object)this.unit, (Object)documentMetadataImageEntry.unit) && Objects.equals(this.width, documentMetadataImageEntry.width) && Objects.equals(this.xRes, documentMetadataImageEntry.xRes) && Objects.equals(this.yRes, documentMetadataImageEntry.yRes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.colorDepth, this.height, this.isAnimated, this.metadata, this.orientation, this.unit, this.width, this.xRes, this.yRes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentMetadataImageEntry {\n");
        sb.append("    colorDepth: ").append(this.toIndentedString(this.colorDepth)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    isAnimated: ").append(this.toIndentedString(this.isAnimated)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    orientation: ").append(this.toIndentedString((Object)this.orientation)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    xRes: ").append(this.toIndentedString(this.xRes)).append("\n");
        sb.append("    yRes: ").append(this.toIndentedString(this.yRes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

