/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains the update information for a document in the document storage")
@JsonPropertyOrder(value={"fileName", "parentDocumentId"})
@JsonTypeName(value="Document_FileUpdate")
public class DocumentFileUpdate {
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName = "";
    public static final String JSON_PROPERTY_PARENT_DOCUMENT_ID = "parentDocumentId";
    private String parentDocumentId = "";

    public DocumentFileUpdate() {
    }

    @JsonCreator
    public DocumentFileUpdate(@JsonProperty(value="parentDocumentId") String parentDocumentId) {
        this();
        this.parentDocumentId = parentDocumentId;
    }

    public DocumentFileUpdate fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(name="File name for the document (without extension)")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Schema(name="The id of the parent document")
    @JsonProperty(value="parentDocumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getParentDocumentId() {
        return this.parentDocumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFileUpdate documentFileUpdate = (DocumentFileUpdate)o;
        return Objects.equals(this.fileName, documentFileUpdate.fileName) && Objects.equals(this.parentDocumentId, documentFileUpdate.parentDocumentId);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.parentDocumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentFileUpdate {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    parentDocumentId: ").append(this.toIndentedString(this.parentDocumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

