/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.AuthAnonymousLimits;
import net.webpdf.wsclient.openapi.AuthUserLimits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Limits for the user")
@JsonPropertyOrder(value={"diskSpaceLimit", "maxFiles", "type", "uploadLimit"})
@JsonTypeName(value="Auth_Limits")
@JsonIgnoreProperties(value={"type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AuthAnonymousLimits.class, name="anonymous"), @JsonSubTypes.Type(value=AuthUserLimits.class, name="user")})
public class AuthLimits {
    public static final String JSON_PROPERTY_DISK_SPACE_LIMIT = "diskSpaceLimit";
    private Integer diskSpaceLimit = 0;
    public static final String JSON_PROPERTY_MAX_FILES = "maxFiles";
    private Integer maxFiles = 0;
    public static final String JSON_PROPERTY_TYPE = "type";
    protected String type = "";
    public static final String JSON_PROPERTY_UPLOAD_LIMIT = "uploadLimit";
    private Integer uploadLimit = 0;

    public AuthLimits diskSpaceLimit(Integer diskSpaceLimit) {
        this.diskSpaceLimit = diskSpaceLimit;
        return this;
    }

    @Schema(name="Maximum size for all uploaded files (in mega byte); 0 = disabled")
    @JsonProperty(value="diskSpaceLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDiskSpaceLimit() {
        return this.diskSpaceLimit;
    }

    @JsonProperty(value="diskSpaceLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiskSpaceLimit(Integer diskSpaceLimit) {
        this.diskSpaceLimit = diskSpaceLimit;
    }

    public AuthLimits maxFiles(Integer maxFiles) {
        this.maxFiles = maxFiles;
        return this;
    }

    @Schema(name="Maximum number of uploaded files; 0 = disabled")
    @JsonProperty(value="maxFiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxFiles() {
        return this.maxFiles;
    }

    @JsonProperty(value="maxFiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxFiles(Integer maxFiles) {
        this.maxFiles = maxFiles;
    }

    public AuthLimits type(String type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public AuthLimits uploadLimit(Integer uploadLimit) {
        this.uploadLimit = uploadLimit;
        return this;
    }

    @Schema(name="Maximum file size for uploads (in mega byte); 0 = disabled")
    @JsonProperty(value="uploadLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getUploadLimit() {
        return this.uploadLimit;
    }

    @JsonProperty(value="uploadLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUploadLimit(Integer uploadLimit) {
        this.uploadLimit = uploadLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthLimits authLimits = (AuthLimits)o;
        return Objects.equals(this.diskSpaceLimit, authLimits.diskSpaceLimit) && Objects.equals(this.maxFiles, authLimits.maxFiles) && Objects.equals(this.type, authLimits.type) && Objects.equals(this.uploadLimit, authLimits.uploadLimit);
    }

    public int hashCode() {
        return Objects.hash(this.diskSpaceLimit, this.maxFiles, this.type, this.uploadLimit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthLimits {\n");
        sb.append("    diskSpaceLimit: ").append(this.toIndentedString(this.diskSpaceLimit)).append("\n");
        sb.append("    maxFiles: ").append(this.toIndentedString(this.maxFiles)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    uploadLimit: ").append(this.toIndentedString(this.uploadLimit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

