/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@JsonPropertyOrder(value={"signatureEditProfile"})
@JsonTypeName(value="ApplicationConfig_SignaturePortalSettings")
public class ApplicationConfigSignaturePortalSettings {
    public static final String JSON_PROPERTY_SIGNATURE_EDIT_PROFILE = "signatureEditProfile";
    private SignatureEditProfileEnum signatureEditProfile = SignatureEditProfileEnum.ADOBE_RESTRICTIONS;

    public ApplicationConfigSignaturePortalSettings signatureEditProfile(SignatureEditProfileEnum signatureEditProfile) {
        this.signatureEditProfile = signatureEditProfile;
        return this;
    }

    @Schema(name="Defines the profile whose rules web services have to check before they can come to execution. These profiles define a set of rules concerning the validity of signatures. A web service whose execution for a given signed document would violate the rule set selected here should instead abort with an appropriate error code.  *   adobeRestrictions = Only those changes are allowed that are enabled by the included signatures. This follows the specifications given by Adobe. *   generalEditRestrictions = All changes to signed documents are prohibited, even those that might be allowed according to the included signatures. *   noEditRestrictions = Editing of signed documents is not restricted and all changes are allowed. (By doing this, you accept the possible invalidation of included signatures.)  **Important:** You can find further explanations of these profiles in the chapter \"Signature Validation\".")
    @JsonProperty(value="signatureEditProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SignatureEditProfileEnum getSignatureEditProfile() {
        return this.signatureEditProfile;
    }

    @JsonProperty(value="signatureEditProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatureEditProfile(SignatureEditProfileEnum signatureEditProfile) {
        this.signatureEditProfile = signatureEditProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigSignaturePortalSettings applicationConfigSignaturePortalSettings = (ApplicationConfigSignaturePortalSettings)o;
        return Objects.equals((Object)this.signatureEditProfile, (Object)applicationConfigSignaturePortalSettings.signatureEditProfile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signatureEditProfile});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigSignaturePortalSettings {\n");
        sb.append("    signatureEditProfile: ").append(this.toIndentedString((Object)this.signatureEditProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SignatureEditProfileEnum {
        ADOBE_RESTRICTIONS(String.valueOf("adobeRestrictions")),
        GENERAL_EDIT_RESTRICTIONS(String.valueOf("generalEditRestrictions")),
        NO_EDIT_RESTRICTIONS(String.valueOf("noEditRestrictions"));

        private String value;

        private SignatureEditProfileEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SignatureEditProfileEnum fromValue(String value) {
            for (SignatureEditProfileEnum b : SignatureEditProfileEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

