/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.webpdf.wsclient.openapi.AdminConfigurationStatusEntry;
import net.webpdf.wsclient.openapi.AdminProviders;
import net.webpdf.wsclient.openapi.AdminServerOS;
import org.jetbrains.annotations.Nullable;

@Schema(description="Provides the server\u00b4s license and version information")
@JsonPropertyOrder(value={"configurations", "hasChangedConfiguration", "licenseIsClusterUsage", "licenseText", "mainVersion", "minorVersion", "providers", "serverPlatform", "serverStart", "serverVersion"})
@JsonTypeName(value="Admin_ServerVersionInfo")
public class AdminServerVersionInfo {
    public static final String JSON_PROPERTY_CONFIGURATIONS = "configurations";
    private Map<String, AdminConfigurationStatusEntry> configurations = null;
    public static final String JSON_PROPERTY_HAS_CHANGED_CONFIGURATION = "hasChangedConfiguration";
    private Boolean hasChangedConfiguration = false;
    public static final String JSON_PROPERTY_LICENSE_IS_CLUSTER_USAGE = "licenseIsClusterUsage";
    private Boolean licenseIsClusterUsage = false;
    public static final String JSON_PROPERTY_LICENSE_TEXT = "licenseText";
    private String licenseText = "";
    public static final String JSON_PROPERTY_MAIN_VERSION = "mainVersion";
    private Integer mainVersion = 0;
    public static final String JSON_PROPERTY_MINOR_VERSION = "minorVersion";
    private Integer minorVersion = 0;
    public static final String JSON_PROPERTY_PROVIDERS = "providers";
    private AdminProviders providers;
    public static final String JSON_PROPERTY_SERVER_PLATFORM = "serverPlatform";
    private AdminServerOS serverPlatform = AdminServerOS.WINDOWS;
    public static final String JSON_PROPERTY_SERVER_START = "serverStart";
    private Long serverStart = 0L;
    public static final String JSON_PROPERTY_SERVER_VERSION = "serverVersion";
    private String serverVersion = "";

    public AdminServerVersionInfo configurations(Map<String, AdminConfigurationStatusEntry> configurations) {
        this.configurations = configurations;
        return this;
    }

    public AdminServerVersionInfo putconfigurationsItem(String key, AdminConfigurationStatusEntry configurationsItem) {
        if (this.configurations == null) {
            this.configurations = new HashMap<String, AdminConfigurationStatusEntry>();
        }
        this.configurations.put(key, configurationsItem);
        return this;
    }

    @Schema(name="All server configurations")
    @JsonProperty(value="configurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Map<String, AdminConfigurationStatusEntry> getConfigurations() {
        return this.configurations;
    }

    @JsonProperty(value="configurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfigurations(Map<String, AdminConfigurationStatusEntry> configurations) {
        this.configurations = configurations;
    }

    public AdminServerVersionInfo hasChangedConfiguration(Boolean hasChangedConfiguration) {
        this.hasChangedConfiguration = hasChangedConfiguration;
        return this;
    }

    @Schema(name="Indicates whether the configuration is currently changed and a restart of the server is necessary to apply the changes.")
    @JsonProperty(value="hasChangedConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHasChangedConfiguration() {
        return this.hasChangedConfiguration;
    }

    @JsonProperty(value="hasChangedConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasChangedConfiguration(Boolean hasChangedConfiguration) {
        this.hasChangedConfiguration = hasChangedConfiguration;
    }

    public AdminServerVersionInfo licenseIsClusterUsage(Boolean licenseIsClusterUsage) {
        this.licenseIsClusterUsage = licenseIsClusterUsage;
        return this;
    }

    @Schema(name="Indicates whether the license can be used for a cluster coordinator or member.")
    @JsonProperty(value="licenseIsClusterUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLicenseIsClusterUsage() {
        return this.licenseIsClusterUsage;
    }

    @JsonProperty(value="licenseIsClusterUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseIsClusterUsage(Boolean licenseIsClusterUsage) {
        this.licenseIsClusterUsage = licenseIsClusterUsage;
    }

    public AdminServerVersionInfo licenseText(String licenseText) {
        this.licenseText = licenseText;
        return this;
    }

    @Schema(name="A string summarizing the server\u00b4s current license.")
    @JsonProperty(value="licenseText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLicenseText() {
        return this.licenseText;
    }

    @JsonProperty(value="licenseText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public AdminServerVersionInfo mainVersion(Integer mainVersion) {
        this.mainVersion = mainVersion;
        return this;
    }

    @Schema(name="The numeric major version of the server.")
    @JsonProperty(value="mainVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMainVersion() {
        return this.mainVersion;
    }

    @JsonProperty(value="mainVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMainVersion(Integer mainVersion) {
        this.mainVersion = mainVersion;
    }

    public AdminServerVersionInfo minorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
        return this;
    }

    @Schema(name="The numeric minor version of the server.")
    @JsonProperty(value="minorVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    @JsonProperty(value="minorVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
    }

    public AdminServerVersionInfo providers(AdminProviders providers) {
        this.providers = providers;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="providers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AdminProviders getProviders() {
        return this.providers;
    }

    @JsonProperty(value="providers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProviders(AdminProviders providers) {
        this.providers = providers;
    }

    public AdminServerVersionInfo serverPlatform(AdminServerOS serverPlatform) {
        this.serverPlatform = serverPlatform;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="serverPlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AdminServerOS getServerPlatform() {
        return this.serverPlatform;
    }

    @JsonProperty(value="serverPlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServerPlatform(AdminServerOS serverPlatform) {
        this.serverPlatform = serverPlatform;
    }

    public AdminServerVersionInfo serverStart(Long serverStart) {
        this.serverStart = serverStart;
        return this;
    }

    @Schema(name="The server start data and time (UTC) as Epoch Unix Timestamp.")
    @JsonProperty(value="serverStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getServerStart() {
        return this.serverStart;
    }

    @JsonProperty(value="serverStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServerStart(Long serverStart) {
        this.serverStart = serverStart;
    }

    public AdminServerVersionInfo serverVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    @Schema(name="A formatted string containing the server\u00b4s name and version.")
    @JsonProperty(value="serverVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getServerVersion() {
        return this.serverVersion;
    }

    @JsonProperty(value="serverVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminServerVersionInfo adminServerVersionInfo = (AdminServerVersionInfo)o;
        return Objects.equals(this.configurations, adminServerVersionInfo.configurations) && Objects.equals(this.hasChangedConfiguration, adminServerVersionInfo.hasChangedConfiguration) && Objects.equals(this.licenseIsClusterUsage, adminServerVersionInfo.licenseIsClusterUsage) && Objects.equals(this.licenseText, adminServerVersionInfo.licenseText) && Objects.equals(this.mainVersion, adminServerVersionInfo.mainVersion) && Objects.equals(this.minorVersion, adminServerVersionInfo.minorVersion) && Objects.equals(this.providers, adminServerVersionInfo.providers) && Objects.equals((Object)this.serverPlatform, (Object)adminServerVersionInfo.serverPlatform) && Objects.equals(this.serverStart, adminServerVersionInfo.serverStart) && Objects.equals(this.serverVersion, adminServerVersionInfo.serverVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configurations, this.hasChangedConfiguration, this.licenseIsClusterUsage, this.licenseText, this.mainVersion, this.minorVersion, this.providers, this.serverPlatform, this.serverStart, this.serverVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminServerVersionInfo {\n");
        sb.append("    configurations: ").append(this.toIndentedString(this.configurations)).append("\n");
        sb.append("    hasChangedConfiguration: ").append(this.toIndentedString(this.hasChangedConfiguration)).append("\n");
        sb.append("    licenseIsClusterUsage: ").append(this.toIndentedString(this.licenseIsClusterUsage)).append("\n");
        sb.append("    licenseText: ").append(this.toIndentedString(this.licenseText)).append("\n");
        sb.append("    mainVersion: ").append(this.toIndentedString(this.mainVersion)).append("\n");
        sb.append("    minorVersion: ").append(this.toIndentedString(this.minorVersion)).append("\n");
        sb.append("    providers: ").append(this.toIndentedString(this.providers)).append("\n");
        sb.append("    serverPlatform: ").append(this.toIndentedString((Object)this.serverPlatform)).append("\n");
        sb.append("    serverStart: ").append(this.toIndentedString(this.serverStart)).append("\n");
        sb.append("    serverVersion: ").append(this.toIndentedString(this.serverVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

