/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.exception;

import java.util.ArrayList;
import java.util.List;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientResultException
extends ResultException {
    @NotNull
    private final List<String> messages = new ArrayList<String>();

    public ClientResultException(@NotNull Error error) {
        this(error, null);
    }

    public ClientResultException(@NotNull Error error, @Nullable Exception cause) {
        super(error, error.getMessage(), error.getCode(), null, cause);
    }

    @Override
    @Nullable
    public String getMessage() {
        String errorMessage = this.getClientError().getMessage();
        String detailMessage = StringUtils.join(this.messages, (String)"\n");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(errorMessage);
        stringBuilder.append(!detailMessage.isEmpty() && stringBuilder.length() > 0 ? "\n" : "");
        stringBuilder.append(detailMessage);
        return stringBuilder.toString();
    }

    @NotNull
    public ResultException appendMessage(@Nullable String message) {
        if (message != null && !message.isEmpty()) {
            this.messages.add(StringUtils.capitalize((String)message));
        }
        return this;
    }

    boolean equalsError(@Nullable Error error) {
        return this.getClientError().equals((Object)error);
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

